package com.utility.powerproxytest;

import android.app.Activity;
import android.os.Bundle;

import android.view.View;
import android.widget.Button;

import android.content.Context;
import android.content.Intent;

import android.util.Log;

public class PowerProxyTestActivity extends Activity
{
    private static final String TAG = "PowerProxyTest";

    private static final String ACTION_POWER_OFF =
	"com.utility.powerproxy.POWER_OFF";
    private static final String ACTION_REBOOT =
	"com.utility.powerproxy.REBOOT";
    private static final String ACTION_SLEEP =
	"com.utility.powerproxy.SLEEP";

    /* since API level 12, defined as Intent.FLAG_INCLUDE_STOPPED_PACKAGES  */
    /* we need to redefined it here for API level 8 */
    public static final int FLAG_INCLUDE_STOPPED_PACKAGES = 0x00000020;

    /* since API level 29, FLAG_RECEIVER_INCLUDE_BACKGROUND is needed */
    /* we need to redefined it here for API level 8 */
    public static final int FLAG_RECEIVER_INCLUDE_BACKGROUND = 0x01000000;

    private Context mContext;

    /** Called when the activity is first created. */
    @Override
	public void onCreate(Bundle savedInstanceState)
    {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.main);

	mContext = this;

	Button button = (Button) findViewById(R.id.button_sleep);
	button.setOnClickListener(new View.OnClickListener() {
		public void onClick(View view) {
		    Intent intent = new Intent(ACTION_SLEEP);
		    intent.addFlags(FLAG_INCLUDE_STOPPED_PACKAGES);
		    intent.addFlags(FLAG_RECEIVER_INCLUDE_BACKGROUND);
		    mContext.sendBroadcast(intent);
		}
	    });

	button = (Button) findViewById(R.id.button_power_off);
	button.setOnClickListener(new View.OnClickListener() {
		public void onClick(View view) {
		    Intent intent = new Intent(ACTION_POWER_OFF);
		    intent.addFlags(FLAG_INCLUDE_STOPPED_PACKAGES);
		    intent.addFlags(FLAG_RECEIVER_INCLUDE_BACKGROUND);
		    mContext.sendBroadcast(intent);
		}
	    });

	button = (Button) findViewById(R.id.button_reset);
	button.setOnClickListener(new View.OnClickListener() {
		public void onClick(View view) {
		    Intent intent = new Intent(ACTION_REBOOT);
		    intent.addFlags(FLAG_INCLUDE_STOPPED_PACKAGES);
		    intent.addFlags(FLAG_RECEIVER_INCLUDE_BACKGROUND);
		    mContext.sendBroadcast(intent);
		}
	    });
    }
}
