#ifndef CVRSDK_H
#define CVRSDK_H

#ifdef _VBEXPORT // "DUMPBIN.EXE /EXPORTS CVRSDK.DLL >> EXPORTS.TXT"

#ifdef CVRSDK_EXPORTS

#define CVRSDK_EXPORT __declspec(dllexport) __stdcall

#else

#define CVRSDK_EXPORT __declspec(dllimport) __stdcall

#endif

#else 

#ifdef CVRSDK_EXPORTS

#define CVRSDK_EXPORT __declspec(dllexport) __cdecl

#else

#define CVRSDK_EXPORT __declspec(dllimport) __cdecl

#endif

#endif

// ##########################################################################################################################################################################################
// #
// # VIDEO RENDERER FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
AFX_EXT_API PVOID CVRSDK_EXPORT CVRSDK_CREATE();

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_DESTROY( PVOID pVideoRenderer /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # CHANNEL WINDOW FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
AFX_EXT_API PVOID CVRSDK_EXPORT CVRSDK_INSERT_CHANNEL_WINDOW( PVOID pVideoRenderer /*IN*/, HWND hDisplayWindow /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_REMOVE_CHANNEL_WINDOW( PVOID pVideoRenderer /*IN*/, PVOID pChannelWindow /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_RESIZE_CHANNEL_WINDOW( PVOID pChannelWindow /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_UPDATE_VIDEO_BUFFER( PVOID pChannelWindow /*IN*/, BYTE * pVideoFrameBuffer /*IN*/, ULONG nVideoColorSpaceType /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SNAPSHOT_BMP( PVOID pChannelWindow /*IN*/, CHAR * pszFilePathName /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SNAPSHOT_JPG( PVOID pChannelWindow /*IN*/, CHAR * pszFilePathName /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # OVERLAY FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
AFX_EXT_API PVOID  CVRSDK_EXPORT CVRSDK_CREATE_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_DESTROY_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_LOCK_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, HDC * pMemoryDC /*OUT*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_UNLOCK_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, HDC hMemoryDC /*IN*/ );

AFX_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SHOW_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, BOOL bShowOverlay /*IN*/, ULONG nPositionX /*IN*/, ULONG nPositionY /*IN*/ );

#endif