// AnalogDeviceVideoGraph.h: interface for the CAnalogDeviceVideoGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_)
#define AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Graph.h"

class CAnalogDeviceVideoGraph : public CGraph  
{
public:

	CAnalogDeviceVideoGraph();

	virtual ~CAnalogDeviceVideoGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					  SC_DEBUG( CHAR * fmt, ... );

	// MEMBER FUNCTIONS
	//
	BOOL					  Close( BOOL bDumpDebugMessage = TRUE );

	BOOL					  Create( PWSTR pwszDevName, HWND hDisplayWindow, PF_BUFFER_CALLBACK pBufferCB, PVOID pUserData );

	BOOL					  GetFormat( ULONG * pColorSpaceType, ULONG * pWidth, ULONG * pHeight, ULONG * pBitCount, double * pFrameRate );

	BOOL					  RefreshDisplayWindow();

	// MEMBER VARIABLES
	// 
	IBaseFilter *             m_pCaptureSourceBaseFilter;

	IBaseFilter *             m_pSampleGrabberBaseFilter;

	IBaseFilter *             m_pColorConverterBaseFilter;

	IBaseFilter *          	  m_pVideoNullRendererBaseFilter;

	CSampleGrabber			  m_oSampleGrabber;
	
	ISampleGrabber * 		  m_pSampleGrabber;

	HWND					  m_hDisplayWindow;

	IVideoWindow *            m_pVideoWindow;

	ULONG					  m_nColorSpaceType;

	ULONG					  m_nWidth;

	ULONG					  m_nHeight;

	ULONG					  m_nBitCount;

	double					  m_dFrameRate;
};

#endif // !defined(AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_)
