// MySwitchLiveAV.cpp: implementation of the MySwitchLiveAV class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MySwitchLiveAV.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern BOOL g_bSaveAVIFile;

extern SYSTEMTIME g_stStartLiveTime[ 32 ];

extern SYSTEMTIME g_stEndLiveTime[ 32 ];

extern double g_dLiveFrameRate[ 32 ];

extern ULONG  g_nLiveVideoFrameNumber[ 32 ];

extern UINT  g_hLiveTimerHandle[ 32  ];

extern CString g_strLiveFrameRate[ 32 ];

extern ULONG g_nRecVideoFrameNumber[ 32 ];

extern ULONG g_n_IsSetThread[ 31 ];

extern PVOID g_pCustomChannelFullWindow;

typedef VOID (*TFCALLBACK)( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime );

VOID LiveTimerProc_2( ULONG nCHID, HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime )
{
	ULONG i = nCHID - 1;

	if ( g_nLiveVideoFrameNumber[ i ] != 0 )
	{
		CTimeSpan timeSpan;

		CTime timeCurrent = CTime::GetCurrentTime();

		CTime timeStart( g_stStartLiveTime[ i ] );

		timeSpan = timeCurrent - timeStart;

		LONGLONG nSeconds = 0;

		nSeconds = timeSpan.GetTotalSeconds();

		if (nSeconds == 0) nSeconds = 1;

		g_dLiveFrameRate[ i ] = (double)g_nLiveVideoFrameNumber[ i ] / (double)nSeconds;

		g_strLiveFrameRate[ i ].Format( "%.3f", g_dLiveFrameRate[ i ] );
	}
}

VOID LiveTimerProc1_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 1, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc2_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 2, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc3_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 3, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc4_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 4, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc5_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 5, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc6_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 6, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc7_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 7, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc8_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 8, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc9_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 9, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc10_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 10, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc11_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 11, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc12_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 12, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc13_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 13, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc14_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 14, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc15_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 15, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc16_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 16, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc17_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 17, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc18_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 18, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc19_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 19, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc20_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 20, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc21_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 21, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc22_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 22, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc23_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 23, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc24_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 24, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc25_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 25, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc26_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 26, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc27_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 27, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc28_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 28, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc29_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 29, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc30_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 30, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc31_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 31, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc32_2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc_2( 32, hWnd, nMsg, nIdEvent, dwTime ); }

TFCALLBACK g_LiveTimerProc2[ 32 ] = 
{  
	LiveTimerProc1_2, LiveTimerProc2_2, LiveTimerProc3_2, LiveTimerProc4_2, LiveTimerProc5_2, LiveTimerProc6_2, LiveTimerProc7_2, LiveTimerProc8_2, LiveTimerProc9_2, LiveTimerProc10_2, LiveTimerProc11_2, LiveTimerProc12_2, LiveTimerProc13_2, LiveTimerProc14_2, LiveTimerProc15_2, LiveTimerProc16_2, LiveTimerProc17_2, LiveTimerProc18_2, LiveTimerProc19_2, LiveTimerProc20_2, LiveTimerProc21_2, LiveTimerProc22_2, LiveTimerProc23_2, LiveTimerProc24_2, LiveTimerProc25_2, LiveTimerProc26_2, LiveTimerProc27_2, LiveTimerProc28_2, LiveTimerProc29_2, LiveTimerProc30_2, LiveTimerProc31_2, LiveTimerProc32_2
};

BOOL on_process_live_video_frame_buffer_2( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	MySwitchLiveAV * pLiveAV = (MySwitchLiveAV *)(pUserData);	

	if ( pLiveAV != NULL )
	{
		if ( pLiveAV->m_nSwitchType == NO_SWICTH_CARD ) { return FALSE; }

		if ( g_nLiveVideoFrameNumber[ i ] == 0 )
		{
			GetLocalTime( &g_stStartLiveTime[ i ] );
		}

		g_nLiveVideoFrameNumber[ i ] += 1;

		MySwEncodeAV * pSwEncodeAV  = NULL;

		MyRecordAV * pRecordAV = NULL;		

		// QUAD SWITCH
		//
		if ( pLiveAV->m_nSwitchType == QUAD_SWITCH_CARD )
		{
			if ( i == 0 || i == 4 || i == 8 || i == 12 || i == 16 || i == 20 || i == 24 || i == 28 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV1; 

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV1; 

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow1, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}

			if ( i == 1 || i == 5 || i == 9 || i == 13 || i == 17 || i == 21 || i == 25 || i == 29 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV2; 

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV2; 

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow2, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}

			if ( i == 2 || i == 6 || i == 10 || i == 14 || i == 18 || i == 22 || i == 26 || i == 30 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV3; 

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV3;

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow3, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}

			if ( i == 3 || i == 7 || i == 11 || i == 15 || i == 19 || i == 23 || i == 27 || i == 31 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV4; 

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV4; 

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow4, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}
		}

		// DOUBLE SWITCH
		//
		if ( pLiveAV->m_nSwitchType == DOUBLE_SWITCH_CARD )
		{
			if ( i == 0 || i == 2 || i == 4 || i == 6 || i == 8 || i == 10 || i == 12 || i == 14 || i == 16 || i == 18 || i == 20 || i == 22 || i == 24 || i == 26 || i == 28 || i == 30 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV1;

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV1;

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow1, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}

			if ( i == 1 || i == 3 || i == 5 || i == 7 || i == 9 || i == 11 || i == 13 || i == 15 || i == 17 || i == 19 || i == 21 || i == 23 || i == 25 || i == 27 || i == 29 || i == 31 ) 
			{ 
				pRecordAV = pLiveAV->m_pRecordAV2;

				pSwEncodeAV = pLiveAV->m_pMySwEncodeAV2;

				if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
				{
					if ( pLiveAV->m_bFullScreen && g_pCustomChannelFullWindow != NULL && pLiveAV->m_nActiveWndID == i )
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( g_pCustomChannelFullWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
					else
					{
						// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
						//
						CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow2, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
					}
				}				
			}
		}		

		if ( pSwEncodeAV != NULL && pRecordAV != NULL )
		{
			BOOL bIsRecord = (pRecordAV->m_nFileRendererRecordState == 0x00000002) ? TRUE : FALSE;

			DEVICE_HANDLE hVideoEncoderDev = pSwEncodeAV->m_hVideoEncoderDev;

			DEVICE_HANDLE hFileDev = pRecordAV->m_hFileRendererDev;

			BOOL bIsRecord2 = TRUE;

			ULONG nDropFrame = pLiveAV->m_nDropFrame;

			// DROP FRAME
			//
			if ( nDropFrame != 0 )
			{
				if ( g_nLiveVideoFrameNumber[ i ] % nDropFrame == 0 ) { bIsRecord2 = TRUE; } else { bIsRecord2 = FALSE; }
			}

			if( bIsKeyFrame )
			{
				// WAITING KEY FRAME
				//
				if( pRecordAV->m_nFileRendererRecordState == 0x00000001 ) 
				{
					pRecordAV->m_nFileRendererRecordState = 0x00000002; // TO GOTO START STATE

					bIsRecord = TRUE;
				}
			}

			bIsRecord &= bIsRecord2; 

			if( bIsRecord ) 
			{
				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferLen = 0;

				BOOL   bIsKeyFrame = FALSE;

				BOOL bSetDIInterlace = FALSE;

				bSetDIInterlace = pLiveAV->SetDIDeinterlace( pBuffer,  nBufferLen );

				// COMPRESSED DATA
				//
				if ( AMESDK_CODEC_ENCODE( hVideoEncoderDev, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pSwEncodeAV->m_nFrameWidth, pSwEncodeAV->m_nFrameHeight, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame ) )
				{
					g_nRecVideoFrameNumber[ i ] += 1;
				}

				// SAVE DATA
				//
				if ( g_bSaveAVIFile )
				{
					AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileDev, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
				}
			}
		}
	}

	// return TRUE;

	return FALSE;
}

BOOL on_process_live_video_frame_buffer_CH01_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH02_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH03_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH04_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH05_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH06_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH07_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH08_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH09_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH10_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH11_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH12_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH13_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH14_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH15_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH16_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH17_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 17, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH18_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 18, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH19_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 19, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH20_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 20, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH21_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 21, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH22_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 22, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH23_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 23, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH24_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 24, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH25_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 25, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH26_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 26, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH27_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 27, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH28_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 28, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH29_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 29, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH30_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 30, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH31_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 31, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH32_2( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer_2( 32, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_live_video_callback2[ 32 ] = 
{  
	on_process_live_video_frame_buffer_CH01_2, 
	on_process_live_video_frame_buffer_CH02_2, 
	on_process_live_video_frame_buffer_CH03_2, 
	on_process_live_video_frame_buffer_CH04_2, 
	on_process_live_video_frame_buffer_CH05_2, 
	on_process_live_video_frame_buffer_CH06_2, 
	on_process_live_video_frame_buffer_CH07_2, 
	on_process_live_video_frame_buffer_CH08_2,
	on_process_live_video_frame_buffer_CH09_2, 
	on_process_live_video_frame_buffer_CH10_2, 
	on_process_live_video_frame_buffer_CH11_2, 
	on_process_live_video_frame_buffer_CH12_2, 
	on_process_live_video_frame_buffer_CH13_2, 
	on_process_live_video_frame_buffer_CH14_2, 
	on_process_live_video_frame_buffer_CH15_2, 
	on_process_live_video_frame_buffer_CH16_2,
	on_process_live_video_frame_buffer_CH17_2, 
	on_process_live_video_frame_buffer_CH18_2, 
	on_process_live_video_frame_buffer_CH19_2, 
	on_process_live_video_frame_buffer_CH20_2, 
	on_process_live_video_frame_buffer_CH21_2, 
	on_process_live_video_frame_buffer_CH22_2, 
	on_process_live_video_frame_buffer_CH23_2, 
	on_process_live_video_frame_buffer_CH24_2,
	on_process_live_video_frame_buffer_CH25_2, 
	on_process_live_video_frame_buffer_CH26_2, 
	on_process_live_video_frame_buffer_CH27_2, 
	on_process_live_video_frame_buffer_CH28_2, 
	on_process_live_video_frame_buffer_CH29_2, 
	on_process_live_video_frame_buffer_CH30_2, 
	on_process_live_video_frame_buffer_CH31_2, 
	on_process_live_video_frame_buffer_CH32_2
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MySwitchLiveAV::MySwitchLiveAV()
{
	m_hVideoDev				= 0xFFFFFFFF;

	m_hDeinterlaceVideoDev = 0xFFFFFFFF;

	m_nSwitchType			= QUAD_SWITCH_CARD;

	m_hWnd1					= NULL;

	m_hWnd2					= NULL;

	m_hWnd3					= NULL;
	
	m_hWnd4					= NULL;

	m_pRecordAV1			= NULL;

	m_pRecordAV2			= NULL;

	m_pRecordAV3			= NULL;

	m_pRecordAV4			= NULL;

	m_pMySwEncodeAV1		= NULL;

	m_pMySwEncodeAV2		= NULL;

	m_pMySwEncodeAV3		= NULL;

	m_pMySwEncodeAV4		= NULL;

	m_pCustomChannelWindow1 = NULL;

	m_pCustomChannelWindow2 = NULL;

	m_pCustomChannelWindow3 = NULL;

	m_pCustomChannelWindow4 = NULL;

	m_bConnect				= FALSE;

	m_nChannelID			= 0;

	m_nDropFrame			= 0;

	m_nWidth				= 352;
	
	m_nHeight				= 240;

	m_bFullScreen			= FALSE;

	m_nActiveWndID			= -1;
}

MySwitchLiveAV::~MySwitchLiveAV()
{
	Disconnect();
}

BOOL MySwitchLiveAV::Connect()
{
	if (m_nChannelID == 0) { return FALSE; }

	if (IsConnected() == TRUE) { return TRUE; }		

	USES_CONVERSION;

	m_hVideoDev = 0xFFFFFFFF;

	int i = m_nChannelID - 1;

	if ( m_strChipName == "TW6802 PCI" || m_strChipName == "SA7160 PCI" )
	{
		if ( m_nSwitchType == QUAD_SWITCH_CARD )
		{
			// OPEN AN ANALOG VIDEO CAPTURE DEVICE
			//
			m_hVideoDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), (m_nChannelID - 1), 0,
				
										 NULL, g_on_live_video_callback2[ ( i * 4 ) + 0 ], this, 
										 
										 NULL, g_on_live_video_callback2[ ( i * 4 ) + 1 ], this, 
										 
										 NULL, g_on_live_video_callback2[ ( i * 4 ) + 2 ], this, 
										 
										 NULL, g_on_live_video_callback2[ ( i * 4 ) + 3 ], this );
		}

		if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
		{
			// OPEN AN ANALOG VIDEO CAPTURE DEVICE
			//
			m_hVideoDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), (m_nChannelID - 1), 0,
				
										 NULL, g_on_live_video_callback2[ ( i * 2 ) + 0 ], this, 
										 
										 NULL, g_on_live_video_callback2[ ( i * 2 ) + 1 ], this );
		}
	}

	m_strChipName.ReleaseBuffer();

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF;

		m_bConnect = FALSE;

		return m_bConnect;
	}
	else
	{
		m_bConnect = TRUE;
	}
	
	m_hDeinterlaceVideoDev = AMESDK_CREATE( "Common Analog Deinterlacer", ( m_nChannelID - 1 ), 16, NULL, NULL, NULL );

	if( m_hDeinterlaceVideoDev & 0x80000000 ) 
	{ 
		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	return m_bConnect;
}

BOOL MySwitchLiveAV::Disconnect()
{
    if (IsConnected() == FALSE)  {  return FALSE;  }

	ResetCalFrameRateTimer();

	BOOL bDisConnect = FALSE;

	if( m_hDeinterlaceVideoDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hDeinterlaceVideoDev ); 

		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		bDisConnect = AMESDK_DESTROY( m_hVideoDev ); 

		m_hVideoDev = 0xFFFFFFFF; 

		m_bConnect = FALSE;	

		return bDisConnect;
	}	
	
	return bDisConnect;
}

BOOL MySwitchLiveAV::SetVideoStandard( ULONG nStandard )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_STANDARD( m_hVideoDev, nStandard );

	return bSet;
}

BOOL MySwitchLiveAV::SetVideoFormat(ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_FORMAT(m_hVideoDev, nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate);

	AMESDK_SET_FORMAT(m_hDeinterlaceVideoDev, nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate);

	m_nWidth = nWidth;
	
	m_nHeight = nHeight;

	return bSet;
}

BOOL MySwitchLiveAV::GetVideoFormat(ULONG * pnColorSpaceType, ULONG * pnWidth, ULONG * pnHeight, ULONG * pnBitCount, DOUBLE * pdFrameRate)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bGet = FALSE;

	bGet = AMESDK_GET_FORMAT(m_hVideoDev, pnColorSpaceType, pnWidth, pnHeight, pnBitCount, pdFrameRate );

	return bGet;
}

BOOL MySwitchLiveAV::SetDIDeinterlace( BYTE * pFrameBuffer, ULONG nFrameBufferSize )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_DI_DEINTERLACE( m_hDeinterlaceVideoDev, pFrameBuffer, nFrameBufferSize );

	return bSet;
}

BOOL MySwitchLiveAV::SetVideoDeinterlace(ULONG nDeinterlace, ULONG nSubChannelNumber)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_DEINTERLACE( m_hVideoDev, nDeinterlace, 0 ); // NOTE!! 352  240 IS PROGRESSIVE FIELD FORMAT

	AMESDK_SET_DEINTERLACE( m_hVideoDev, nDeinterlace, 1 );

	AMESDK_SET_DEINTERLACE( m_hDeinterlaceVideoDev, nDeinterlace, 0 );

	AMESDK_SET_DEINTERLACE( m_hDeinterlaceVideoDev, nDeinterlace, 1 );

	return bSet;
}

BOOL MySwitchLiveAV::SetVideoProperty(ULONG nProperty, ULONG nValue, ULONG nSubChannelNumber)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hVideoDev, nProperty, nValue, nSubChannelNumber );

	return bSet;
}

BOOL MySwitchLiveAV::SetCustomProperty(ULONG nProperty, ULONG nValue)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDev, nProperty, nValue );

	return bSet;
}

BOOL MySwitchLiveAV::LiveRun()
{
	if (IsConnected() == FALSE) { return FALSE; }
	
	BOOL bRun = AMESDK_RUN( m_hVideoDev );	
		 
	ResetCalFrameRateTimer();

	int i = m_nChannelID - 1;

	int j = ( i * 4 ) + 0;

	int m = 0;

	if ( m_nSwitchType == QUAD_SWITCH_CARD )
	{
		for ( m = j ; m < (j + 4) ; m++  )
		{
			g_hLiveTimerHandle[ m ] = ::SetTimer( NULL, 0x00000001, 1000, (TIMERPROC) g_LiveTimerProc2[ m ] );
		}
	}	

	if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
	{
		for ( m = j ; m < (j + 2) ; m++  )
		{
			g_hLiveTimerHandle[ m ] = ::SetTimer( NULL, 0x00000001, 1000, (TIMERPROC) g_LiveTimerProc2[ m ] );
		}
	}

	return bRun;
}

BOOL MySwitchLiveAV::LiveStop()
{
	if (IsConnected() == FALSE) { return FALSE; }
	
	BOOL bStop = AMESDK_STOP( m_hVideoDev );

	ResetCalFrameRateTimer();

	return bStop;
}

BOOL MySwitchLiveAV::RefreshDisplay( ULONG nSubChannelNumber )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bFresh = AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev, nSubChannelNumber );	

	return bFresh;
}

BOOL MySwitchLiveAV::SnapshotBMP(CHAR *pszFilePathName)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSnapshot = FALSE;

	bSnapshot = AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDev, pszFilePathName );

	return bSnapshot;
}

BOOL MySwitchLiveAV::SnapshotJPG(CHAR *pszFilePathName, ULONG nQuality)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSnapshot = FALSE;

	bSnapshot = AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev, pszFilePathName, nQuality );	

	return bSnapshot;
}

BOOL MySwitchLiveAV::SetVideoInput(ULONG nInput)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_INPUT( m_hVideoDev, nInput );	

	return bSet;
}

BOOL MySwitchLiveAV::SetSwitchTable( BYTE TABLE[] )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_CUSTOM_PROPERTY_EX( m_hVideoDev, 206, TABLE, 12 ); // SET SWITCH TABLE

	return bSet;
}

VOID MySwitchLiveAV::ResetCalFrameRateTimer()
{
	int i = m_nChannelID - 1;

	int j = ( i * 4 ) + 0;

	int m = 0;

	if ( m_nSwitchType == QUAD_SWITCH_CARD )
	{
		for ( m = j ; m < (j + 4) ; m++  )
		{
			g_nLiveVideoFrameNumber[ m ] = 0;

			::KillTimer( NULL, g_hLiveTimerHandle[ m ] );

			g_hLiveTimerHandle[ m ] = 0;
		}
	}

	if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
	{
		for ( m = j ; m < (j + 2) ; m++  )
		{
			g_nLiveVideoFrameNumber[ m ] = 0;

			::KillTimer( NULL, g_hLiveTimerHandle[ m ] );

			g_hLiveTimerHandle[ m ] = 0;
		}
	}
}