// StreamCatcherDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"
#include <math.h>
#include <iostream>
#include <fstream>
using namespace std;

#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

// INITIALIZE STATIC CLASS VARIABLE 
//
sc510Dlg*	sc510Dlg::s_psc510Dlg = 0;

//  FORMAT CHANGED CALLBACK FUNCTION
//

//QRETURN on_video_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
//{
//	//Dbg( "on_video_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );
//
//	return QCAP_RT_OK;
//}

QRETURN on_video_decoder_3d_file_callback( PVOID pFile, UINT iChNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
//	SC_DEBUG( "on_video_decoder_file_callback( %d, %f, %d )", iChNum, dSampleTime, nFrameBufferLen );

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	//Dbg( "on_audio_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
	Dbg( "on_snapshot_done_callback( %s )", pszFilePathName );

	return QCAP_RT_OK;
}


/////////////////////////////////////////////////////////////////////////////
// sc510Dlg dialog

sc510Dlg::sc510Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(sc510Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(sc510Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void sc510Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(sc510Dlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(sc510Dlg, CDialog)
	//{{AFX_MSG_MAP(sc510Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// sc510Dlg message handlers

void sc510Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// CDialog::OnOK();
}

void sc510Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	// CDialog::OnCancel();
}

BOOL sc510Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here


	// INITIALIZE MEMBER VARIABLES
	//

	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000001, NULL ); // VIDEO WINDOW

		m_oChannelWindows[ 1 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000002, NULL ); // BACKGROUND WINDOW

		//m_oCloneWindows.Create( NULL, "MyCloneWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 0, 0 ), this, 0x10000001, NULL ); // BACKGROUND WINDOW

		// INITIALIZE MAIN WINDOW
		//
		{	CRect oWindowRect; GetWindowRect( &oWindowRect );

			CRect oClientRect; GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 0 ].MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].ShowWindow( FALSE );

		}

		// INITIALIZE SETUP DIALOG
		//
		{	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

			MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
			GetMonitorInfo( hMonitor, &sMonitorInfo );

			CRect oMonitorRect = sMonitorInfo.rcWork;			
			
			m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

			CRect oWindowRect; m_oSetupDialog.GetWindowRect( &oWindowRect );

			CRect oClientRect; m_oSetupDialog.GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2,

														  (oMonitorRect.Height() - (250 +  + cy)),
														  
														  (cx + 430), 

														  (cy + 310),
														  
														  (NULL));
			m_oSetupDialog.ShowWindow( TRUE );
		}

		SetWindowText( "" DEFAULT_PRODUCT ", " DEFAULT_PRODUCT_VERSION );	
	}

	m_pFile = NULL;

	m_nVideoFormat = 0;

	m_nVideoWidth = 0;

	m_nVideoHeight = 0;

	m_dVideoFrameRate = 0;

	m_nAudioFormat = 0;

	m_nAudioChannels = 0;

	m_nAudioBitsPerSample = 0;

	m_nAudioSampleFrequency = 0;

	m_dFileTotalDuationTimes = 0;

	m_nFileTotalVideoFrames = 0;

	m_nFileTotalAudioFrames = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void sc510Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR sc510Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL sc510Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CRect rect_client;	GetClientRect( &rect_client );

	CBrush brush_fill_rect( RGB(0, 0, 0) );

	pDC->FillRect( &rect_client, &brush_fill_rect );

	return CWnd::OnEraseBkgnd(pDC);
}

BOOL sc510Dlg::OnLButtonDblClk_ChannelWindow() 
{
	// TODO: Add your message handler code here and/or call default
	
	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	CRect oWindowRect; GetWindowRect( &oWindowRect );

	if ( oWindowRect.Width() < oMonitorRect.Width() ) {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		MoveWindow( oMonitorRect );
	}
	else {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, 960, 540 );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, 960, 540 );

		MoveWindow( (oMonitorRect.Width() - 960) / 2, (oMonitorRect.Height() - 540) / 2, 960, 540 );	
	}	

	return TRUE;
}

BOOL sc510Dlg::OnButtonOPEN_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "AVI, ASF, FLV, MP4, TS\0*.AVI;*.ASF;*.FLV;*.MP4;*.TS\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			QCAP_DESTROY_FILE( m_pFile );

			m_pFile = NULL;
		}
		BOOL bIs3D = FALSE;

		QCAP_OPEN_3D_FILE( psz, &m_pFile, &bIs3D, QCAP_DECODER_TYPE_INTEL_MEDIA_SDK, 
			
						  &m_nVideoFormat, &m_nVideoWidth, &m_nVideoHeight, &m_dVideoFrameRate, 
						  
						  &m_nAudioFormat, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency, 
						  
						  &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, 
						  
						   m_oChannelWindows[ 0 ], TRUE, FALSE, 
						  
						   NULL, TRUE, FALSE );

//		QCAP_OPEN_3D_FILE( psz, &m_pFile, QCAP_DECODER_TYPE_INTEL_MEDIA_SDK, 
//			
//						  &m_nVideoFormat, &m_nVideoWidth, &m_nVideoHeight, &m_dVideoFrameRate, 
//						  
//						  &m_nAudioFormat, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency, 
//						  
//						  &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, 
//						  
//						   m_statWindowL.m_hWnd, TRUE, FALSE, 
//						  
//						   m_statWindowR.m_hWnd, TRUE, FALSE );

		QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK( m_pFile, on_video_decoder_3d_file_callback, this );

		QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pFile, on_audio_decoder_file_callback, this );

		QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pFile, on_snapshot_done_callback, this );

		QCAP_PAUSE_FILE( m_pFile );

		double speed = 0;

		QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

		//CHAR psz_info[ 512 ];

		CString vfmt;

		CString afmt;

		if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

		sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

		//m_editFilePath.SetWindowText( psz_info );

		//SetTimer( 0x00000000,  10, NULL );

		//SetTimer( 0x00000001, 100, NULL );
	}

	return TRUE;
}

BOOL sc510Dlg::OnButtonPLAY_SetupDialog() 
{
	double dSampleTime = 0;

	QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

	if( dSampleTime >= m_dFileTotalDuationTimes ) {

		QCAP_STOP_FILE( m_pFile );
	}
	QCAP_PLAY_FILE( m_pFile );

	return TRUE;
}

BOOL sc510Dlg::OnButtonPAUSE_SetupDialog() 
{
	QCAP_PAUSE_FILE( m_pFile );

	return TRUE;
}

BOOL sc510Dlg::OnButtonSTOP_SetupDialog() 
{

	QCAP_STOP_FILE( m_pFile );

	return TRUE;
}

BOOL sc510Dlg::OnButtonSPEEDUP_SetupDialog() 
{
	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed += 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

	//CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	//m_editFilePath.SetWindowText( psz_info );

	return TRUE;
}

BOOL sc510Dlg::OnButtonSPEEDDOWN_SetupDialog() 
{

	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed -= 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

	//CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	//m_editFilePath.SetWindowText( psz_info );

	return TRUE;
}

BOOL sc510Dlg::OnButtonSNAPSHOT_SetupDialog() 
{

	QCAP_SNAPSHOT_FILE_BMP( m_pFile, "TEST.BMP"  );

	return TRUE;
}

BOOL sc510Dlg::OnButtonANALYSIS_SetupDialog() 
{

	CString str_path;

	//CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\n", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

	{	CHAR psz[ MAX_PATH ];

		GetModuleFileName( NULL, psz, MAX_PATH );

		str_path = psz;

		str_path = str_path.Left( str_path.ReverseFind('\\') + 1 );

		str_path += "ANALYSIS.LOG";
	}
	ofstream file;

	file.open( str_path );

	file << psz_info;
	
	ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

	BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

	double dLastSampleTime = 0;

	file << "\r\n[VIDEO STREAM]\r\n\r\n";

	for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		BOOL   bIsKeyFrame = FALSE;

		double dSampleTime = 0;

		QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X] %s\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ], bIsKeyFrame ? "[I]" : "" );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}

	file << "\r\n[AUDIO STREAM]\r\n\r\n";

	dLastSampleTime = 0;

	for(ULONG i = 0 ; i < m_nFileTotalAudioFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		double dSampleTime = 0;

		QCAP_GET_AUDIO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X]\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ] );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}
	file.close();

	if( pStreamBuffer ) {

		free( pStreamBuffer );

		pStreamBuffer = NULL;
	}

	AfxMessageBox( "PLEASE CHECK ANALYSIS.LOG" );

	return TRUE;
}

void sc510Dlg::OnDestroy() 
{
	//KillTimer( 0x00000001 );

	if( m_pFile ) {

		QCAP_DESTROY_FILE( m_pFile );

		m_pFile = NULL;
	}
	//CString strFilePath;

	//m_oSetupDialog.m_editFilePath.GetWindowText( strFilePath );

	//m_progTimeBar.SetRange( 0, 200 );

	{	m_oChannelWindows[ 0 ].DestroyWindow();

		m_oChannelWindows[ 1 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}


void sc510Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	

	CDialog::OnTimer(nIDEvent);
}

void sc510Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );
}

