﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace AnimationFactory
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        [DllImport("kernel32.dll")]
        static extern bool WriteProfileString(string lpAppName, string lpKeyName, string lpString);

        [DllImport("kernel32.dll")]
        static extern uint GetProfileString(string lpAppName, string lpKeyName, string lpDefault, [Out] StringBuilder lpReturnedString, uint nSize);

        public uint i = 0;

        string m_strChipName = "SA7160 PCI";

        public uint[] m_pDevices = new uint[4];

        public uint[] m_nDeviceVideoWidths = new uint[4];

        public uint[] m_nDeviceVideoHeights = new uint[4];

        public uint[] m_nDeviceAudioChannels = new uint[4];

        public uint[] m_nDeviceAudioBitsPerSamples = new uint[4];

        public uint[] m_nDeviceAudioSampleFrequencys = new uint[4];

        public uint m_pClip;

        public uint m_nClipFrames;

        public uint m_nClipSprites;        

        public uint m_nClipColorSpaceType;

        public uint m_nClipWidth;

        public uint m_nClipHeight;

        public volatile uint m_nShareRecordState;

        // CRITICAL SECTION OBJECT
        // 
        public Object m_hShareRecordAccessCriticalSection = new Object();

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;        

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            m_nDeviceVideoWidths[nCH] = nVideoWidth;

            m_nDeviceVideoHeights[nCH] = nVideoHeight;

            m_nDeviceAudioChannels[nCH] = nAudioChannels;

            m_nDeviceAudioBitsPerSamples[nCH] = nAudioBitsPerSample;

            m_nDeviceAudioSampleFrequencys[nCH] = nAudioSampleFrequency;            

            OutputDebugString("on_format_changed_callback ( " + (nCH + 1).ToString() + " , " + nVideoWidth.ToString() + " , " + nAudioChannels.ToString() + " , " + nAudioBitsPerSample.ToString() + " , " + nAudioSampleFrequency .ToString() + " )  \n");
           
            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            if (nCH == 0)
            {
                // ENTER CRITICAL SECTION
                //
                lock (m_hShareRecordAccessCriticalSection)
                {
                    if (m_nShareRecordState > 0x00000000)
                    {
                        uint iFrameNum = 0;

                        uint pClipFrameBuffer = 0, nClipFrameBufferLen = 0;

                        EXPORTS.QCAP_STEP_ANIMATION_CLIP(m_pClip, ref iFrameNum, ref pClipFrameBuffer, ref nClipFrameBufferLen);

                        if ( pClipFrameBuffer > 0)
                        {
                            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, m_nClipColorSpaceType, m_nClipWidth, m_nClipHeight, pClipFrameBuffer, nClipFrameBufferLen);
                        }
                    }
                }
                //
                // LEAVE CRITICAL SECTION 
            }           
            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }        

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            if (nCH == 0)
            {
                // ENTER CRITICAL SECTION
                //
                lock (m_hShareRecordAccessCriticalSection)
                {
                    if (m_nShareRecordState > 0x00000000)
                    {
                        EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen);
                    }
                }
                //
                // LEAVE CRITICAL SECTION               
            }           

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            m_nDeviceVideoWidths[nCH] = 0;

            m_nDeviceVideoHeights[nCH] = 0;

            m_nDeviceAudioChannels[nCH] = 0;

            m_nDeviceAudioBitsPerSamples[nCH] = 0;

            m_nDeviceAudioSampleFrequencys[nCH] = 0;

            OutputDebugString("CH" + (nCH + 1).ToString() + " No Signal Detected  \n");

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            m_nDeviceVideoWidths[nCH] = 0;

            m_nDeviceVideoHeights[nCH] = 0;

            m_nDeviceAudioChannels[nCH] = 0;

            m_nDeviceAudioBitsPerSamples[nCH] = 0;

            m_nDeviceAudioSampleFrequencys[nCH] = 0;

            OutputDebugString("CH" + (nCH + 1).ToString() + " Signal Removed \n");

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            for (i = 0; i < 4; i++)
            {
                m_pDevices[i] = 0;

                m_nDeviceVideoWidths[i] = 0;

                m_nDeviceVideoHeights[i] = 0;

                m_nDeviceAudioChannels[i] = 0;

                m_nDeviceAudioBitsPerSamples[i] = 0;

                m_nDeviceAudioSampleFrequencys[i] = 0;
            }

            m_pClip = 0;

            m_nClipFrames = 0;

            m_nClipSprites = 0;

            m_nClipColorSpaceType = 0x00000000;

            m_nClipWidth = 0;

            m_nClipHeight = 0;

            m_nShareRecordState = 0x00000000;

            StringBuilder lpReturnedString = new StringBuilder("EXAMPLE.QUAD", 256);  

            GetProfileString("DEFAULT", "FILE.PATH", "", lpReturnedString, 256);

            m_editFilePath.Text = lpReturnedString.ToString();

            // INITIALIZE DEVICE RESOURCE
            //
            EXPORTS.QCAP_CREATE(ref m_strChipName, 0, (uint)m_statChannelWindow0.Handle.ToInt32(), ref m_pDevices[0], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 1, (uint)m_statChannelWindow1.Handle.ToInt32(), ref m_pDevices[1], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 2, (uint)m_statChannelWindow2.Handle.ToInt32(), ref m_pDevices[2], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 3, (uint)m_statChannelWindow3.Handle.ToInt32(), ref m_pDevices[3], 1);

            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_pDevices[0], m_pFormatChangedCB, 0);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_pDevices[1], m_pFormatChangedCB, 1);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_pDevices[2], m_pFormatChangedCB, 2);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_pDevices[3], m_pFormatChangedCB, 3);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_pDevices[0], m_pPreviewVideoCB, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_pDevices[1], m_pPreviewVideoCB, 1);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_pDevices[2], m_pPreviewVideoCB, 2);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_pDevices[3], m_pPreviewVideoCB, 3);          

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_pDevices[0], m_pPreviewAudioCB, 0);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_pDevices[1], m_pPreviewAudioCB, 1);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_pDevices[2], m_pPreviewAudioCB, 2);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_pDevices[3], m_pPreviewAudioCB, 3);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_pDevices[0], m_pNoSignalDetectedCB, 0);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_pDevices[1], m_pNoSignalDetectedCB, 1);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_pDevices[2], m_pNoSignalDetectedCB, 2);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_pDevices[3], m_pNoSignalDetectedCB, 3);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_pDevices[0], m_pSignalRemovedCB, 0);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_pDevices[1], m_pSignalRemovedCB, 1);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_pDevices[2], m_pSignalRemovedCB, 2);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_pDevices[3], m_pSignalRemovedCB, 3);

            EXPORTS.QCAP_RUN(m_pDevices[0]);

            EXPORTS.QCAP_RUN(m_pDevices[1]);

            EXPORTS.QCAP_RUN(m_pDevices[2]);

            EXPORTS.QCAP_RUN(m_pDevices[3]);

            btnStart.Enabled = true;

            btnStop.Enabled = false;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            // STOP SHARE RECORDING
            //
            btnStop_Click(sender, e);

            // UNINITIALIZE DEVICE RESOURCE
            // 
            for (i = 0; i < 4; i++)
            {
                if (m_pDevices[i] != 0)
                {
                    EXPORTS.QCAP_STOP(m_pDevices[i]);

                    EXPORTS.QCAP_DESTROY(m_pDevices[i]);

                    m_pDevices[i] = 0;
                }
            }

            string strFilePath;

            strFilePath = m_editFilePath.Text;

            WriteProfileString("DEFAULT", "FILE.PATH", strFilePath);
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();

            dialog.Filter = "XML files (*.xml)|*.xml|All files (*.*)|*.*";

            dialog.InitialDirectory = Application.StartupPath;

            dialog.Title = "Select a XML file";

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                m_editFilePath.Text = dialog.FileName;

                OutputDebugString(dialog.FileName + " \n");                

                btnStop_Click(sender, e);
            }
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            string strFilePath;

            strFilePath = m_editFilePath.Text;

            if (strFilePath.Length == 0) { return;  }

            btnStop_Click(sender, e);

            // INITIALIZE ANIMATION RESOURCE
            // 
            EXPORTS.QCAP_CREATE_ANIMATION_CLIP(ref strFilePath, ref m_pClip, ref m_nClipFrames, ref m_nClipSprites, ref m_nClipColorSpaceType, ref m_nClipWidth, ref m_nClipHeight);

            if (m_pClip != 0)
            {
                EXPORTS.QCAP_START_ANIMATION_CLIP(m_pClip);

                EXPORTS.QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE(m_pClip, 0, m_pDevices[0]);

                EXPORTS.QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE(m_pClip, 1, m_pDevices[1]);

                EXPORTS.QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE(m_pClip, 2, m_pDevices[2]);

                EXPORTS.QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE(m_pClip, 3, m_pDevices[3]);
            }
            else
            {
                return;
            }

            // INITIALIZE SHARE RECORDING RESOURCE
            // 
            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, m_nClipColorSpaceType, m_nClipWidth, m_nClipHeight, 30, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, (uint)m_statShareWindow.Handle.ToInt32(), 1, 0);

            EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, m_nDeviceAudioChannels[0], m_nDeviceAudioBitsPerSamples[0], m_nDeviceAudioSampleFrequencys[0], 100);

            string pszFilePathName = "DEMO.MP4";

            EXPORTS.QCAP_START_SHARE_RECORD(0, ref pszFilePathName, (uint)EXPORTS.RecordFlagEnum.QCAP_RECORD_FLAG_FULL);

            lock (m_hShareRecordAccessCriticalSection)
            {
                m_nShareRecordState = 0x00000001;
            }

            btnStart.Enabled = false;

            btnStop.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            // UNINITIALIZE SHARE RECORDING
            //
            lock (m_hShareRecordAccessCriticalSection)
            {
                m_nShareRecordState = 0x00000000;
            }

            EXPORTS.QCAP_STOP_SHARE_RECORD(0);

            // UNINITIALIZE ANIMATION CLIP
            //
            if (m_pClip != 0)
            {

                EXPORTS.QCAP_STOP_ANIMATION_CLIP(m_pClip);

                EXPORTS.QCAP_DESTROY_ANIMATION_CLIP(m_pClip);

                m_pClip = 0;
            }

            btnStart.Enabled = true;

            btnStop.Enabled = false;           
        }
    }
}
