// VideoInputDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "VideoInputDlg.h"
#include "afxdialogex.h"

// CVideoInputDlg dialog

IMPLEMENT_DYNAMIC(CVideoInputDlg, CDialog)

CVideoInputDlg::CVideoInputDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVideoInputDlg::IDD, pParent)
{

}

CVideoInputDlg::~CVideoInputDlg()
{
}

void CVideoInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CVideoInputDlg, CDialog)
	//{{AFX_MSG_MAP(CVideoInputDlg)
	ON_BN_CLICKED(IDC_RADIO_INPUT_HDMI, OnRadioInputHdmi)
	ON_BN_CLICKED(IDC_RADIO_INPUT_DVID, OnRadioInputDvid)
	ON_BN_CLICKED(IDC_RADIO_INPUT_COMPONENTS, OnRadioInputComponents)
	ON_BN_CLICKED(IDC_RADIO_INPUT_DVIA, OnRadioInputDvia)
	ON_BN_CLICKED(IDC_RADIO_INPUT_SDI, OnRadioInputSdi)
	ON_BN_CLICKED(IDC_RADIO_INPUT_COMPOSITE, OnRadioInputComposite)
	ON_BN_CLICKED(IDC_RADIO_INPUT_SVIDEO, OnRadioInputSvideo)
	ON_BN_CLICKED(IDC_RADIO_INPUT_AUTO, OnRadioInputAuto)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CVideoInputDlg message handlers

BOOL CVideoInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	ULONG inputs = 0;

	if ( m_pMainDialog->m_hVideoDevice[ nChannelNum ] != NULL ) 
	{
		QCAP_GET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], &inputs );

		if( inputs == 0 ) { CheckDlgButton( IDC_RADIO_INPUT_COMPOSITE, BST_CHECKED ); }

		if( inputs == 1 ) { CheckDlgButton( IDC_RADIO_INPUT_SVIDEO, BST_CHECKED ); }

		if( inputs == 2 ) { CheckDlgButton( IDC_RADIO_INPUT_HDMI, BST_CHECKED ); }

		if( inputs == 3 ) { CheckDlgButton( IDC_RADIO_INPUT_DVID, BST_CHECKED ); }

		if( inputs == 4 ) { CheckDlgButton( IDC_RADIO_INPUT_COMPONENTS, BST_CHECKED ); }

		if( inputs == 5 ) { CheckDlgButton( IDC_RADIO_INPUT_DVIA, BST_CHECKED ); }

		if( inputs == 6 ) { CheckDlgButton( IDC_RADIO_INPUT_SDI, BST_CHECKED ); }

		if( inputs == 7 ) { CheckDlgButton( IDC_RADIO_INPUT_AUTO, BST_CHECKED ); }
	}

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CVideoInputDlg::OnRadioInputHdmi() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000002 );

	CDialog::OnOK();	
}

void CVideoInputDlg::OnRadioInputDvid() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000003 );

	CDialog::OnOK();
}

void CVideoInputDlg::OnRadioInputComponents() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000004 );

	CDialog::OnOK();		
}

void CVideoInputDlg::OnRadioInputDvia() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000005 );

	CDialog::OnOK();	
}

void CVideoInputDlg::OnRadioInputSdi() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000006 );

	CDialog::OnOK();		
}

void CVideoInputDlg::OnRadioInputComposite() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000000 );

	CDialog::OnOK();		
}

void CVideoInputDlg::OnRadioInputSvideo() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000001 );

	CDialog::OnOK();	
}

void CVideoInputDlg::OnRadioInputAuto() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	QCAP_SET_VIDEO_INPUT( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0x00000007 );

	CDialog::OnOK();	
}
