﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo2
{
    public partial class Form1 : Form
    {
        //[DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        //public static extern void OutputDebugString(string message);

        public struct tagQcap
        {
            public CChannelWindow m_oChannelWindows2;
            public uint m_hVideoDevice;
            public uint m_nVideoWidth;
            public uint m_nVideoHeight;
            public double m_dVideoFrameRate;
            public uint m_bHorizontalMirror;
            public uint m_bVerticalMirror;

            public bool SetDefauleValue()
	        {
                m_oChannelWindows2 = new CChannelWindow();
	            m_hVideoDevice = 0;
                m_nVideoWidth = 0;
                m_nVideoHeight = 0;
                m_dVideoFrameRate = 0;
                m_bHorizontalMirror = 0;
                m_bVerticalMirror = 0;

                return true;
	        }
        }
        public tagQcap[] strQcap = new tagQcap[4];

        public struct tagSetupRecordPropertyEx
        {
	        public int		nResult;
	        public bool		bSetting;

	        public string 	pszRecordFilePathName;

	        public uint		nEncoderType;
	        public uint		nEncoderFormat;
	        public uint		nRecordProfile;
	        public uint		nRecordLevel;
	        public uint		nRecordEntropy;
	        public uint		nRecordComplexity;
	        public uint		nRecordMode;
	        public uint		nQuality;
	        public uint		nBitRate;
	        public uint		nGOP;
	        public uint		nBFrames;
	        public bool		bIsInterleaved;
	        public uint		nAspectRatioX;
	        public uint		nAspectRatioY;
	        public uint		nCropX;
	        public uint		nCropY;
	        public uint		nCropW;
	        public uint		nCropH;
	        public uint		nDstW;
	        public uint		nDstH;

	        public uint		nPostSkipFrameRate;
	        public uint		nPostAvgFrameRate;
	        public uint		nPostFrameRateStatus;

	        public uint		nFileSplittingSize;		// KB
	        public uint		nFileSplittingTime;		// SEC
	        public uint		nFileSplittingStatus;

	        public uint		nRecordScale;
        //
        //	SUB PARAMETERS
        //
	        public uint		nEncoderType2;
	        public uint		nEncoderFormat2;
	        public uint		nRecordProfile2;
	        public uint		nRecordLevel2;
	        public uint		nRecordEntropy2;
	        public uint		nRecordComplexity2;
	        public uint		nRecordMode2;
	        public uint		nQuality2;
	        public uint		nBitRate2;
	        public uint		nGOP2;
	        public uint		nBFrames2;
	        public bool		bIsInterleaved2;
	        public uint		nAspectRatioX2;
	        public uint		nAspectRatioY2;
	        public uint		nCropX2;
	        public uint		nCropY2;
	        public uint		nCropW2;
	        public uint		nCropH2;
	        public uint		nDstW2;
	        public uint		nDstH2;

	        public uint		nPostSkipFrameRate2;
	        public uint		nPostAvgFrameRate2;
	        public uint		nPostFrameRateStatus2;

	        public uint		nFileSplittingSize2;		// KB
	        public uint		nFileSplittingTime2;		// SEC
	        public uint		nFileSplittingStatus2;

	        public uint		nRecordScale2;
	
	        public bool SetDefaulVlaue()
	        {	
                // GET CURRENT DIRECTORY
                //
                pszRecordFilePathName = Directory.GetCurrentDirectory() + "\\";

		        nResult						= 0;

		        bSetting					= false;

		        nEncoderType				= 0;				// (0)QCAP_ENCODER_TYPE_SOFTWARE(1)QCAP_ENCODER_TYPE_HARDWARE(2)QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK(3)QCAP_ENCODER_TYPE_AMD_STREAM(4)QCAP_ENCODER_TYPE_NVIDIA_CUDA(5)QCAP_ENCODER_TYPE_NVIDIA_NVENC
		        nEncoderFormat				= 0;				// (0)QCAP_ENCODER_FORMAT_H264(1)QCAP_ENCODER_FORMAT_MPEG2(2)QCAP_ENCODER_FORMAT_H264_3D
		        nRecordProfile				= 0;				// (0)QCAP_RECORD_PROFILE_BASELINE(1)QCAP_RECORD_PROFILE_MAIN(2)QCAP_RECORD_PROFILE_HIGH
		        nRecordLevel				= 41;				// (0)QCAP_RECORD_LEVEL_1(41)QCAP_RECORD_LEVEL_41,...(52)QCAP_RECORD_LEVEL_52...
		        nRecordEntropy				= 0;				// (0)QCAP_RECORD_ENTROPY_CAVLC(1)QCAP_RECORD_ENTROPY_CABAC
		        nRecordComplexity			= 0;				// (0)QCAP_RECORD_COMPLEXITY_0~(6)QCAP_RECORD_COMPLEXITY_6
		        nRecordMode					= 1;				// (0)QCAP_RECORD_MODE_VBR(1)QCAP_RECORD_MODE_CBR(2)QCAP_RECORD_MODE_ABR
		        nQuality					= 8000;
		        nBitRate					= 4000000;
		        nGOP						= 30;
		        nBFrames					= 0;
		        bIsInterleaved				= false;
		        nAspectRatioX				= 0;
		        nAspectRatioY				= 0;
		        nCropX						= 0;
		        nCropY						= 0;
		        nCropW						= 0;
		        nCropH						= 0;
		        nDstW						= 0;
		        nDstH						= 0;
		        nPostSkipFrameRate			= 0;
		        nPostAvgFrameRate			= 25;
		        nPostFrameRateStatus		= 0;

		        nFileSplittingSize			= 0;	// MB
		        nFileSplittingTime			= 0;	// SEC
		        nFileSplittingStatus		= 0;

		        nRecordScale				= 0;
        //
        //	SUB
        //
		        nEncoderType2				= 0;				// (0)QCAP_ENCODER_TYPE_SOFTWARE(1)QCAP_ENCODER_TYPE_HARDWARE(2)QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK(3)QCAP_ENCODER_TYPE_AMD_STREAM(4)QCAP_ENCODER_TYPE_NVIDIA_CUDA(5)QCAP_ENCODER_TYPE_NVIDIA_NVENC
		        nEncoderFormat2				= 0;				// (0)QCAP_ENCODER_FORMAT_H264(1)QCAP_ENCODER_FORMAT_MPEG2(2)QCAP_ENCODER_FORMAT_H264_3D
		        nRecordProfile2				= 1;				// (0)QCAP_RECORD_PROFILE_BASELINE(1)QCAP_RECORD_PROFILE_MAIN(2)QCAP_RECORD_PROFILE_HIGH
		        nRecordLevel2				= 41;				// (0)QCAP_RECORD_LEVEL_1(41)QCAP_RECORD_LEVEL_41,...(52)QCAP_RECORD_LEVEL_52...
		        nRecordEntropy2				= 0;				// (0)QCAP_RECORD_ENTROPY_CAVLC(1)QCAP_RECORD_ENTROPY_CABAC
		        nRecordComplexity2			= 0;				// (0)QCAP_RECORD_COMPLEXITY_0~(6)QCAP_RECORD_COMPLEXITY_6
		        nRecordMode2				= 1;				// (0)QCAP_RECORD_MODE_VBR(1)QCAP_RECORD_MODE_CBR(2)QCAP_RECORD_MODE_ABR
		        nQuality2					= 8000;
		        nBitRate2					= 2000000;
		        nGOP2						= 30;
		        nBFrames2					= 0;
		        bIsInterleaved2				= false;
		        nAspectRatioX2				= 0;
		        nAspectRatioY2				= 0;
		        nCropX2						= 0;
		        nCropY2						= 0;
		        nCropW2						= 0;
		        nCropH2						= 0;
		        nDstW2						= 0;
		        nDstH2						= 0;
		        nPostSkipFrameRate2			= 0;
		        nPostAvgFrameRate2			= 25;
		        nPostFrameRateStatus2		= 0;

		        nFileSplittingSize2			= 0;	// MB
		        nFileSplittingTime2			= 0;	// SEC
		        nFileSplittingStatus2		= 0;

		        nRecordScale2				= 0;

                return true;
	        }	
        }

        public tagSetupRecordPropertyEx g_scmProtypeEx = new tagSetupRecordPropertyEx();

        public uint m_hNetworkServer = 0;

        public volatile uint m_nNetworkServerState = 0;

        public CPropertyDlg oPropertyDlg = new CPropertyDlg();

        public Form1 GetMainForm() { return this; }
         
        // FOURCC MARCO
        //
        uint MAKEFOURCC(uint ch0, uint ch1, uint ch2, uint ch3)
        {
            return ((uint)(byte)(ch0) | ((uint)(byte)(ch1) << 8) | ((uint)(byte)(ch2) << 16) | ((uint)(byte)(ch3) << 24));
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nID = (uint)pUserData;

            if (m_nNetworkServerState > 0x00000000 && m_hNetworkServer != 0)
            {
                EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hNetworkServer, nID, pFrameBuffer, nFrameBufferLen);
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // VIDEO HARDWARE ENCODER CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_hardware_encoder_video_buffer_00(uint pDevice, uint iRecNum, double dSampleTime, uint pStreamBuffer, uint nStreamBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nID = (uint)pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // VIDEO HARDWARE ENCODER CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_hardware_encoder_video_buffer_01(uint pDevice, uint iRecNum, double dSampleTime, uint pStreamBuffer, uint nStreamBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nID = (uint)pUserData;

            if (m_nNetworkServerState > 0x00000000 && m_hNetworkServer != 0)
            {
                EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER(m_hNetworkServer, nID, pStreamBuffer, nStreamBufferLen, bIsKeyFrame);
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // CALLBACK FUNCTION
        //        
//        EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pVideoHardwareEncoderCallback_00;

        EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pVideoHardwareEncoderCallback_01;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        string m_strChipName = "TW5864 PCI";

        private void Form1_Load(object sender, EventArgs e)
        {
            // CREATE CHANNEL WINDOW
            //
            for (uint i = 0; i < 4; i++)
            {
                strQcap[i].SetDefauleValue();

                strQcap[i].m_oChannelWindows2.Parent = this;

                // LEFT POSITION
                //
                if (i == 0) { strQcap[i].m_oChannelWindows2.Left = 0; }

                if (i == 1) { strQcap[i].m_oChannelWindows2.Left = (960) / 2; }

                if (i == 2) { strQcap[i].m_oChannelWindows2.Left = 0; }

                if (i == 3) { strQcap[i].m_oChannelWindows2.Left = (960) / 2; }

                // TOP POSITION
                //
                if (i == 0) { strQcap[i].m_oChannelWindows2.Top = 0; }

                if (i == 1) { strQcap[i].m_oChannelWindows2.Top = 0; }

                if (i == 2) { strQcap[i].m_oChannelWindows2.Top = (540) / 2; }

                if (i == 3) { strQcap[i].m_oChannelWindows2.Top = (540) / 2; }

                // WIDTH & HEIGHT
                //
                strQcap[i].m_oChannelWindows2.Size = new System.Drawing.Size((960) / 2, (540) / 2);

                strQcap[i].m_oChannelWindows2.Visible = true;

                strQcap[i].m_oChannelWindows2.m_nChannelNumber = i + 1;
            }

            uint n_pos_x = 960;

            uint n_pos_y = 0;

            uint n_crl_width = 190;

            uint n_crl_height = (540 / 2) / 3;

            m_btnStreamStart.Left = (int)(n_pos_x + (0 * n_crl_width));

            m_btnStreamStart.Top = (int)(n_pos_y + (0 * n_crl_height));

            m_btnStreamStop.Left = (int)(n_pos_x + (1 * n_crl_width));

            m_btnStreamStop.Top = (int)(n_pos_y + (0 * n_crl_height));

            m_btnRecordStart.Left = (int)(n_pos_x + (0 * n_crl_width));

            m_btnRecordStart.Top = (int)(n_pos_y + (1 * n_crl_height));

            m_btnRecordStop.Left = (int)(n_pos_x + (1 * n_crl_width));

            m_btnRecordStop.Top = (int)(n_pos_y + (1 * n_crl_height));

            m_btnSetting.Left = (int)(n_pos_x + (0 * n_crl_width));

            m_btnSetting.Top = (int)(n_pos_y + (2 * n_crl_height));

            m_btnMirrorh.Left = (int)(n_pos_x + (0 * n_crl_width));

            m_btnMirrorh.Top = (int)(n_pos_y + (3 * n_crl_height));

            m_btnMirrorv.Left = (int)(n_pos_x + (1 * n_crl_width));

            m_btnMirrorv.Top = (int)(n_pos_y + (3 * n_crl_height));

            m_btnSnapJpg.Left = (int)(n_pos_x + (0 * n_crl_width));

            m_btnSnapJpg.Top = (int)(n_pos_y + (4 * n_crl_height));

            m_btnSnapBmp.Left = (int)(n_pos_x + (1 * n_crl_width));

            m_btnSnapBmp.Top = (int)(n_pos_y + (4 * n_crl_height));

            m_btnStreamStart.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnStreamStop.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnRecordStart.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnRecordStop.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnSetting.Size = new System.Drawing.Size((int)n_crl_width * 2, (int)n_crl_height);

            m_btnMirrorh.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnMirrorv.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnSnapJpg.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);

            m_btnSnapBmp.Size = new System.Drawing.Size((int)n_crl_width, (int)n_crl_height);
            //
            // UPDATE USER INTERFACE RESOURCE
            //
            m_btnStreamStart.Enabled = true;

            m_btnStreamStop.Enabled = false;

            m_btnRecordStart.Enabled = true;

            m_btnRecordStop.Enabled = false;
            //
            //
            //
            HwInitialize();

            g_scmProtypeEx.SetDefaulVlaue();
            //
            // USER INTERFACE PROGRAMMING (SETUP CONTROL)
            //
            oPropertyDlg = new CPropertyDlg();
            oPropertyDlg.m_pMainForm = GetMainForm();
        }

        public Form1()
        {
            InitializeComponent();
        }

        bool HwUninitialize()
        {
            for (uint i = 0; i < 4; i++)
            {
                if (strQcap[i].m_hVideoDevice != 0)
                {
                    EXPORTS.QCAP_STOP(strQcap[i].m_hVideoDevice);

                    EXPORTS.QCAP_DESTROY(strQcap[i].m_hVideoDevice);

                    strQcap[i].m_hVideoDevice = 0;
                }
            }

            return true;
        }

        bool HwInitialize()
        {
	        uint nStandard = 0x10;

            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            m_pVideoHardwareEncoderCallback_01 = new EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK(on_process_hardware_encoder_video_buffer_01);

            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            for (uint i = 0; i < 4; i++)
            {
                // CREATE CAPTURE DEVICE            
                //
                EXPORTS.QCAP_CREATE( ref m_strChipName, i, (uint)strQcap[i].m_oChannelWindows2.Handle.ToInt32(), ref strQcap[i].m_hVideoDevice, 1);

                // REGISTER FORMAT CHANGED CALLBACK FUNCTION
                //
                EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(strQcap[i].m_hVideoDevice, m_pFormatChangedCB, i);

                // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
                //
                EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(strQcap[i].m_hVideoDevice, m_pPreviewVideoCB, 0);

                //// REGISTER VIDEO HARDWARE ENCODER CALLBACK FUNCTION
                ////
                //m_pVideoHardwareEncoderCallback_00 = new EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK(on_process_hardware_encoder_video_buffer_00);

                //EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(strQcap[i].m_hVideoDevice, 0, m_pVideoHardwareEncoderCallback_00, i);

                // REGISTER VIDEO HARDWARE ENCODER CALLBACK FUNCTION
                //
                EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(strQcap[i].m_hVideoDevice, 1, m_pVideoHardwareEncoderCallback_01, i);

                // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
                // 
                EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(strQcap[i].m_hVideoDevice, m_pPreviewAudioCB, i);

                // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
                //
                EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(strQcap[i].m_hVideoDevice, m_pNoSignalDetectedCB, i);

                // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
                //
                EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(strQcap[i].m_hVideoDevice, m_pSignalRemovedCB, i);

                // SET INPUT
                //
                EXPORTS.QCAP_SET_VIDEO_INPUT(strQcap[i].m_hVideoDevice, 0);

                // RUN DEVICE
                //
                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(strQcap[i].m_hVideoDevice, 0);

                EXPORTS.QCAP_SET_VIDEO_STANDARD(strQcap[i].m_hVideoDevice, nStandard);
                //
                // SET TIMESTAMP OSD
                //
                byte[] pbyOsd = new byte[] { 0x00 };

                EXPORTS.QCAP_SET_DEVICE_CUSTOM_PROPERTY(strQcap[i].m_hVideoDevice, 920, 0x00);

                EXPORTS.QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX(strQcap[i].m_hVideoDevice, 921, (uint)(EXPORTS.QCAP_HELPER_OBJPTR(ref pbyOsd[0])), (uint)pbyOsd.Length);

                EXPORTS.QCAP_RUN(strQcap[i].m_hVideoDevice);
            }

            return true;
        }

        public bool OnRecordStop()
        {
            for (uint i = 0; i < 4; i++)
            {
                EXPORTS.QCAP_STOP_RECORD(strQcap[i].m_hVideoDevice, 0);

                EXPORTS.QCAP_STOP_RECORD(strQcap[i].m_hVideoDevice, 1);
            }

            return true;
        }

        public bool OnRecordStart()
        {
            string str1_temp, str2_temp;

            uint nPostSkipFrameRate = g_scmProtypeEx.nPostSkipFrameRate;
            uint nPostAvgFrameRate = g_scmProtypeEx.nPostAvgFrameRate;
            uint nPostFrameRateStatus = g_scmProtypeEx.nPostFrameRateStatus;

            uint nFileSplittingSize = g_scmProtypeEx.nFileSplittingSize;
            uint nFileSplittingTime = g_scmProtypeEx.nFileSplittingTime;
            uint nFileSplittingStatus = g_scmProtypeEx.nFileSplittingStatus;

            uint nRecordScale = g_scmProtypeEx.nRecordScale;

            if (nFileSplittingSize == 0) { nFileSplittingSize = 0; }
            if (nFileSplittingSize == 1) { nFileSplittingSize = 1024; }
            if (nFileSplittingSize == 2) { nFileSplittingSize = 1024 * 5; }
            if (nFileSplittingSize == 3) { nFileSplittingSize = 1024 * 10; }
            if (nFileSplittingSize == 4) { nFileSplittingSize = 1024 * 20; }
            if (nFileSplittingSize == 5) { nFileSplittingSize = 1024 * 40; }
            if (nFileSplittingSize == 6) { nFileSplittingSize = 1024 * 80; }
            if (nFileSplittingSize == 7) { nFileSplittingSize = 1024 * 160; }
            if (nFileSplittingSize == 8) { nFileSplittingSize = 1024 * 320; }

            if (nFileSplittingTime == 0) { nFileSplittingTime = 0; }
            if (nFileSplittingTime == 1) { nFileSplittingTime = 60; }
            if (nFileSplittingTime == 2) { nFileSplittingTime = 60 * 2; }
            if (nFileSplittingTime == 3) { nFileSplittingTime = 60 * 3; }
            if (nFileSplittingTime == 4) { nFileSplittingTime = 60 * 4; }
            if (nFileSplittingTime == 5) { nFileSplittingTime = 60 * 5; }
            if (nFileSplittingTime == 6) { nFileSplittingTime = 60 * 6; }
            if (nFileSplittingTime == 7) { nFileSplittingTime = 60 * 7; }

            if (nRecordScale == 0) { nRecordScale = 0; }
            if (nRecordScale == 1) { nRecordScale = 2; }
            //
            //	SUB
            //
            uint nPostSkipFrameRate2 = g_scmProtypeEx.nPostSkipFrameRate2;
            uint nPostAvgFrameRate2 = g_scmProtypeEx.nPostAvgFrameRate2;
            uint nPostFrameRateStatus2 = g_scmProtypeEx.nPostFrameRateStatus2;

            uint nFileSplittingSize2 = g_scmProtypeEx.nFileSplittingSize2;
            uint nFileSplittingTime2 = g_scmProtypeEx.nFileSplittingTime2;
            uint nFileSplittingStatus2 = g_scmProtypeEx.nFileSplittingStatus2;

            uint nRecordScale2 = g_scmProtypeEx.nRecordScale2;

            if (nFileSplittingSize2 == 0) { nFileSplittingSize2 = 0; }
            if (nFileSplittingSize2 == 1) { nFileSplittingSize2 = 1024; }
            if (nFileSplittingSize2 == 2) { nFileSplittingSize2 = 1024 * 5; }
            if (nFileSplittingSize2 == 3) { nFileSplittingSize2 = 1024 * 10; }
            if (nFileSplittingSize2 == 4) { nFileSplittingSize2 = 1024 * 20; }
            if (nFileSplittingSize2 == 5) { nFileSplittingSize2 = 1024 * 40; }
            if (nFileSplittingSize2 == 6) { nFileSplittingSize2 = 1024 * 80; }
            if (nFileSplittingSize2 == 7) { nFileSplittingSize2 = 1024 * 160; }
            if (nFileSplittingSize2 == 8) { nFileSplittingSize2 = 1024 * 320; }

            if (nFileSplittingTime2 == 0) { nFileSplittingTime2 = 0; }
            if (nFileSplittingTime2 == 1) { nFileSplittingTime2 = 60; }
            if (nFileSplittingTime2 == 2) { nFileSplittingTime2 = 60 * 2; }
            if (nFileSplittingTime2 == 3) { nFileSplittingTime2 = 60 * 3; }
            if (nFileSplittingTime2 == 4) { nFileSplittingTime2 = 60 * 4; }
            if (nFileSplittingTime2 == 5) { nFileSplittingTime2 = 60 * 5; }
            if (nFileSplittingTime2 == 6) { nFileSplittingTime2 = 60 * 6; }
            if (nFileSplittingTime2 == 7) { nFileSplittingTime2 = 60 * 7; }

            if (nRecordScale2 == 0) { nRecordScale2 = 0; }
            if (nRecordScale2 == 1) { nRecordScale2 = 2; }

            for (uint i = 0; i < 4; i++)
            {
                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(strQcap[i].m_hVideoDevice, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC);

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(strQcap[i].m_hVideoDevice, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC);

                EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(strQcap[i].m_hVideoDevice, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF);

                EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(strQcap[i].m_hVideoDevice, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_2);

                str1_temp = g_scmProtypeEx.pszRecordFilePathName + "MAIN_CH" + i + "_.$Y.$M.$D.$h.$m.$ss.$i.MP4";

                str2_temp = g_scmProtypeEx.pszRecordFilePathName + "SUB_CH" + i + "_.$Y.$M.$D.$h.$m.$ss.$i.MP4";

                if (nFileSplittingStatus == 0)
                {
                    EXPORTS.QCAP_START_RECORD(strQcap[i].m_hVideoDevice, 0, ref str1_temp, 7, 0, 0, 0, nFileSplittingSize);
                }
                if (nFileSplittingStatus == 1)
                {
                    EXPORTS.QCAP_START_RECORD(strQcap[i].m_hVideoDevice, 0, ref str1_temp, 7, 0, 0, nFileSplittingTime, 0); 
                }
                if (nFileSplittingStatus2 == 0)
                {
                   EXPORTS.QCAP_START_RECORD(strQcap[i].m_hVideoDevice, 1, ref str2_temp, 7, 0, 0, 0, nFileSplittingSize2);
                }
                if (nFileSplittingStatus2 == 1)
                {
                   EXPORTS.QCAP_START_RECORD(strQcap[i].m_hVideoDevice, 1, ref str2_temp, 7, 0, 0, nFileSplittingTime2, 0); 
                }
            }

            return true;
        }

        public bool OnStreamStop()
        {
            m_nNetworkServerState = 0x00000000;

            if (m_hNetworkServer != 0)
            {
                EXPORTS.QCAP_STOP_BROADCAST_SERVER(m_hNetworkServer);

                EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hNetworkServer);

                m_hNetworkServer = 0;
            }

            return true;
        }
        public bool OnStreamStart()
        {
	        OnStreamStop();

            uint nPostFrameRateStatus = g_scmProtypeEx.nPostFrameRateStatus;
            uint nPostSkipFrameRate = g_scmProtypeEx.nPostSkipFrameRate;
            uint nPostAvgFrameRate = g_scmProtypeEx.nPostAvgFrameRate;

	        double dFps = 0.0;
	        uint nStandard = 25;
	
	        if( nPostFrameRateStatus == 0 )
	        {	
		        for( uint i = 0; i < 7; i++ )
		        { 	
			        if( i > 0 )
			        {
                        if (g_scmProtypeEx.nPostSkipFrameRate2 == i)
				        {
					        dFps = nStandard / (i+1);
				        }			
			        }
		        }	
	        }
	        if( nPostFrameRateStatus == 1 )
	        {
                dFps = g_scmProtypeEx.nPostAvgFrameRate2;	
	        }

            String strAccount = "root";

            String strPassword = "root";

            EXPORTS.QCAP_CREATE_BROADCAST_RTSP_SERVER(0, 4, ref m_hNetworkServer, ref strAccount, ref strPassword, 554);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), 720, 480, nStandard, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, 0, 0, 0, (uint)(EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_NETWORK));

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), 720, 480, nStandard, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, 0, 0, 0, (uint)(EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_NETWORK));

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), 720, 480, nStandard, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, 0, 0, 0, (uint)(EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_NETWORK));

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 3, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), 720, 480, nStandard, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, 0, 0, 0, (uint)(EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_NETWORK));
  
            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 3, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 1, 16, 8000, 100);

            EXPORTS.QCAP_START_BROADCAST_SERVER(m_hNetworkServer);

	        m_nNetworkServerState = 0x00000001;

	        return true;
        }

        private void m_btnStreamStart_Click(object sender, EventArgs e)
        {
            OnStreamStart();

            m_btnStreamStart.Enabled = false;

            m_btnStreamStop.Enabled = true;

            m_btnSetting.Enabled = false;
        }

        private void m_btnStreamStop_Click(object sender, EventArgs e)
        {
            OnStreamStop();

            m_btnStreamStart.Enabled = true;

            m_btnStreamStop.Enabled = false;

            if (m_btnRecordStop.Enabled != true) { m_btnSetting.Enabled = true; }            
        }

        private void m_btnRecordStart_Click(object sender, EventArgs e)
        {
            OnRecordStart();

            m_btnRecordStart.Enabled = false;

            m_btnRecordStop.Enabled = true;

            m_btnSetting.Enabled = false;
        }

        private void m_btnRecordStop_Click(object sender, EventArgs e)
        {
            OnRecordStop();

            m_btnRecordStart.Enabled = true;

            m_btnRecordStop.Enabled = false;

            if (m_btnStreamStop.Enabled != true) { m_btnSetting.Enabled = true; }
        }

        private void m_btnMirrorh_Click(object sender, EventArgs e)
        {
            for (uint i = 0; i < 4; i++)
            {
                bool bFag = false;
                if (strQcap[i].m_bHorizontalMirror == 0) {
                    strQcap[i].m_bHorizontalMirror = 1;
                    bFag = true;
                }
                if (strQcap[i].m_bHorizontalMirror == 1 && (bFag == false)) {                    
                   strQcap[i].m_bHorizontalMirror = 0;
                }
                EXPORTS.QCAP_SET_VIDEO_MIRROR(strQcap[i].m_hVideoDevice, strQcap[i].m_bHorizontalMirror, strQcap[i].m_bVerticalMirror);
             }
        }

        private void m_btnMirrorv_Click(object sender, EventArgs e)
        {
            for (uint i = 0; i < 4; i++)
            {
                bool bFag = false;
                if (strQcap[i].m_bVerticalMirror == 0) {
                    strQcap[i].m_bVerticalMirror = 1;
                    bFag = true;
                }
                if (strQcap[i].m_bVerticalMirror == 1 && (bFag == false))
                {
                    strQcap[i].m_bVerticalMirror = 0;
                }
                EXPORTS.QCAP_SET_VIDEO_MIRROR(strQcap[i].m_hVideoDevice, strQcap[i].m_bHorizontalMirror, strQcap[i].m_bVerticalMirror);
            }
        }

        private void m_btnSnapJpg_Click(object sender, EventArgs e)
        {
            string str;

            for (uint i = 0; i < 4; i++)
            {
                str = g_scmProtypeEx.pszRecordFilePathName + "CH" + i + ".JPG";

                EXPORTS.QCAP_SNAPSHOT_JPG(strQcap[i].m_hVideoDevice, ref str, 100);
            }
        }

        private void m_btnSnapBmp_Click(object sender, EventArgs e)
        {
            string str;

            for (uint i = 0; i < 4; i++)
            {
                str = g_scmProtypeEx.pszRecordFilePathName + "CH" + i + ".BMP";

                EXPORTS.QCAP_SNAPSHOT_BMP(strQcap[i].m_hVideoDevice, ref str);
            }
        }

        private void m_btnSetting_Click(object sender, EventArgs e)
        {
            m_btnRecordStart.Enabled = false;

            m_btnRecordStop.Enabled = false;

            m_btnStreamStart.Enabled = false;

            m_btnStreamStop.Enabled = false;

            oPropertyDlg.Show();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_nNetworkServerState = 0x00000000;

            OnRecordStop();

            OnStreamStop();
            //
            // UNINITIALIZE DEVICE RESOURCE
            //
            HwUninitialize(); 
        }
    }
}
