// PropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC3B0.h"
#include "SC3B0Dlg.h"
#include "PropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern STRUCT_SRPEX g_scmProtypeEx;

extern CPropertyDlg *g_pPropertyDlg;

extern BOOL g_bRecordApply;

/////////////////////////////////////////////////////////////////////////////
// CPropertyDlg dialog


CPropertyDlg::CPropertyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPropertyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPropertyDlg)
	m_editRecordPath = _T("");
	m_editRecordBitrate = 0;
	m_editRecordGop = 0;
	m_editRecordQuality = 0;
	m_editRecordQuality2 = 0;
	m_editRecordGop2 = 0;
	m_editRecordBitrate2 = 0;
	//}}AFX_DATA_INIT
}


void CPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropertyDlg)
	DDX_Control(pDX, IDC_COMBO_RECORD_SCAL2, m_comboRecordScale2);
	DDX_Control(pDX, IDC_COMBO_RECORD_SCAL, m_comboRecordScale);
	DDX_Control(pDX, IDC_COMBO_RECORD_TIME2, m_comboFileTime2);
	DDX_Control(pDX, IDC_COMBO_RECORD_SIZE2, m_comboFileSize2);
	DDX_Control(pDX, IDC_COMBO_RECORD_MODE2, m_comboRecordMode2);
	DDX_Control(pDX, IDC_COMBO_RECORD_ENTROPY2, m_comboRecordEntropy2);
	DDX_Control(pDX, IDC_COMBO_RECORD_PROFILE2, m_comboRecordProfile2);
	DDX_Control(pDX, IDC_COMBO_ENCODE_FORMAT2, m_comboRecorFormat2);
	DDX_Control(pDX, IDC_COMBO_ENCODE_TYPE2, m_comboEncodeType2);
	DDX_Control(pDX, IDC_COMBO_RECORD_SKIP2, m_comboRecordSkipFrame2);
	DDX_Control(pDX, IDC_COMBO_RECORD_AVG2, m_comboRecordAvgFrame2);
	DDX_Control(pDX, IDC_COMBO_RECORD_TIME, m_comboFileTime);
	DDX_Control(pDX, IDC_COMBO_RECORD_SIZE, m_comboFileSize);
	DDX_Control(pDX, IDC_COMBO_RECORD_AVG, m_comboRecordAvgFrame);
	DDX_Control(pDX, IDC_COMBO_RECORD_SKIP, m_comboRecordSkipFrame);
	DDX_Control(pDX, IDC_COMBO_RECORD_PROFILE, m_comboRecordProfile);
	DDX_Control(pDX, IDC_COMBO_RECORD_MODE, m_comboRecordMode);
	DDX_Control(pDX, IDC_COMBO_RECORD_ENTROPY, m_comboRecordEntropy);
	DDX_Control(pDX, IDC_COMBO_ENCODE_TYPE, m_comboEncodeType);
	DDX_Control(pDX, IDC_COMBO_ENCODE_FORMAT, m_comboRecorFormat);
	DDX_Text(pDX, IDC_EDIT_RECORD_PATH, m_editRecordPath);
	DDX_Text(pDX, IDC_EDIT_RECORD_BITRATE, m_editRecordBitrate);
	DDV_MinMaxUInt(pDX, m_editRecordBitrate, 1000, 64000000);
	DDX_Text(pDX, IDC_EDIT_RECORD_GOP, m_editRecordGop);
	DDV_MinMaxUInt(pDX, m_editRecordGop, 0, 255);
	DDX_Text(pDX, IDC_EDIT_RECORD_QUALITY, m_editRecordQuality);
	DDV_MinMaxUInt(pDX, m_editRecordQuality, 0, 10000);
	DDX_Text(pDX, IDC_EDIT_RECORD_QUALITY2, m_editRecordQuality2);
	DDV_MinMaxUInt(pDX, m_editRecordQuality2, 0, 10000);
	DDX_Text(pDX, IDC_EDIT_RECORD_GOP2, m_editRecordGop2);
	DDV_MinMaxUInt(pDX, m_editRecordGop2, 0, 255);
	DDX_Text(pDX, IDC_EDIT_RECORD_BITRATE2, m_editRecordBitrate2);
	DDV_MinMaxUInt(pDX, m_editRecordBitrate2, 1000, 64000000);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropertyDlg, CDialog)
	//{{AFX_MSG_MAP(CPropertyDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnButtonSave)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropertyDlg message handlers

void CPropertyDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CPropertyDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CPropertyDlg::OnButtonSave() 
{
	// TODO: Add your control notification handler code here

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;
	
    char szPath[ 1024 ];     

    CString str;

    ZeroMemory( szPath, sizeof(szPath) );   

    BROWSEINFO bi;
	bi.hwndOwner		= NULL;
    bi.pidlRoot			= NULL;
    bi.pszDisplayName	= szPath;
    bi.lpszTitle		= "Select Record Path:";   
    bi.ulFlags			= BIF_EDITBOX | BIF_VALIDATE;
    bi.lpfn				= NULL;   
    bi.lParam			= 0;
    bi.iImage			= 0;
    
    LPITEMIDLIST lp		= SHBrowseForFolder(&bi);

    if( lp && SHGetPathFromIDList( lp, szPath ) )
	{
		if( strlen(szPath) < 4  ) 
		{
			str.Format( "%s",  szPath );
		}
		else
		{
			str.Format( "%s\\",  szPath );
		}
		sprintf( pScm->pszRecordFilePathName, "%s", str);
		
		m_editRecordPath = str; 

		UpdateData(FALSE);
	}
    else
	{
		AfxMessageBox("The direction does not exist");   	
	}
}

void CPropertyDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	CSC3B0Dlg *pMainDlg = CSC3B0Dlg::s_pMainDlg;

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;

	CHAR sz[512] = {0};
//
//	CONFIG SETUP PARAMS
//
	lstrcpy( pScm->pszRecordFilePathName, (CHAR*)(LPCSTR)m_editRecordPath );

	pScm->nRecordScale = m_comboRecordScale.GetCurSel();

	pScm->nPostSkipFrameRate = 	m_comboRecordSkipFrame.GetCurSel();

	pScm->nPostAvgFrameRate = m_comboRecordAvgFrame.GetCurSel();

	pScm->nFileSplittingSize = 	m_comboFileSize.GetCurSel();

	pScm->nFileSplittingTime = m_comboFileTime.GetCurSel();

	pScm->nRecordEntropy = m_comboRecordEntropy.GetCurSel();
	
	pScm->nRecordMode = m_comboRecordMode.GetCurSel();

	pScm->nQuality = m_editRecordQuality;

	pScm->nBitRate = m_editRecordBitrate;

	pScm->nGOP = m_editRecordGop;

	BOOL bSkip = ((CButton*)GetDlgItem( IDC_RADIO_SKIP ))->GetCheck();
	BOOL bAvg = ((CButton*)GetDlgItem( IDC_RADIO_AVG ))->GetCheck();
	if( bSkip ){ pScm->nPostFrameRateStatus = 0; }
	if( bAvg ){ pScm->nPostFrameRateStatus = 1; }

	BOOL bSize = ((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE ))->GetCheck();
	BOOL bTime = ((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME ))->GetCheck();
	if( bSize ){ pScm->nFileSplittingStatus = 0; }
	if( bTime ){ pScm->nFileSplittingStatus = 1; }
//
//	SUB
//
	pScm->nRecordScale2 = m_comboRecordScale2.GetCurSel();

	pScm->nPostSkipFrameRate2 = m_comboRecordSkipFrame2.GetCurSel();

	pScm->nPostAvgFrameRate2 = m_comboRecordAvgFrame2.GetCurSel();

	pScm->nFileSplittingSize2 = m_comboFileSize2.GetCurSel();

	pScm->nFileSplittingTime2 = m_comboFileTime2.GetCurSel();

	pScm->nRecordEntropy2 = m_comboRecordEntropy2.GetCurSel();
	
	pScm->nRecordMode2 = m_comboRecordMode2.GetCurSel();

	pScm->nQuality2 = m_editRecordQuality2;

	pScm->nBitRate2 = m_editRecordBitrate2;

	pScm->nGOP2 = m_editRecordGop2;

	BOOL bSkip2 = ((CButton*)GetDlgItem( IDC_RADIO_SKIP2 ))->GetCheck();
	BOOL bAvg2 = ((CButton*)GetDlgItem( IDC_RADIO_AVG2 ))->GetCheck();
	if( bSkip2 ){ pScm->nPostFrameRateStatus2 = 0; }
	if( bAvg2 ){ pScm->nPostFrameRateStatus2 = 1; }

	BOOL bSize2 = ((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE2 ))->GetCheck();
	BOOL bTime2 = ((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME2 ))->GetCheck();
	if( bSize2 ){ pScm->nFileSplittingStatus2 = 0; }
	if( bTime2 ){ pScm->nFileSplittingStatus2 = 1; }
//
// SET HARDWARE H.264 PARAMETERS
//
	ULONG	nPostSkipFrameRate	= pScm->nPostSkipFrameRate;
	ULONG	nPostAvgFrameRate	= pScm->nPostAvgFrameRate;
	ULONG	nPostFrameRateStatus = pScm->nPostFrameRateStatus;

	ULONG	nFileSplittingSize	= pScm->nFileSplittingSize;
	ULONG	nFileSplittingTime	= pScm->nFileSplittingTime;
	ULONG	nFileSplittingStatus = pScm->nFileSplittingStatus;

	ULONG	nRecordScale = pScm->nRecordScale;

	if( nFileSplittingSize == 0 ) { nFileSplittingSize = 0; }
	if( nFileSplittingSize == 1 ) { nFileSplittingSize = 1024; }
	if( nFileSplittingSize == 2 ) { nFileSplittingSize = 1024*5; }
	if( nFileSplittingSize == 3 ) { nFileSplittingSize = 1024*10; }
	if( nFileSplittingSize == 4 ) { nFileSplittingSize = 1024*20; }
	if( nFileSplittingSize == 5 ) { nFileSplittingSize = 1024*40; }
	if( nFileSplittingSize == 6 ) { nFileSplittingSize = 1024*80; }
	if( nFileSplittingSize == 7 ) { nFileSplittingSize = 1024*160; }
	if( nFileSplittingSize == 8 ) { nFileSplittingSize = 1024*320; }

	if( nFileSplittingTime == 0 ) { nFileSplittingTime = 0; }
	if( nFileSplittingTime == 1 ) { nFileSplittingTime = 60; }
	if( nFileSplittingTime == 2 ) { nFileSplittingTime = 60*2; }
	if( nFileSplittingTime == 3 ) { nFileSplittingTime = 60*3; }
	if( nFileSplittingTime == 4 ) { nFileSplittingTime = 60*4; }
	if( nFileSplittingTime == 5 ) { nFileSplittingTime = 60*5; }
	if( nFileSplittingTime == 6 ) { nFileSplittingTime = 60*6; }
	if( nFileSplittingTime == 7 ) { nFileSplittingTime = 60*7; }
//
//	SUB
//
	ULONG	nPostSkipFrameRate2	= pScm->nPostSkipFrameRate2;
	ULONG	nPostAvgFrameRate2	= pScm->nPostAvgFrameRate2;
	ULONG	nPostFrameRateStatus2 = pScm->nPostFrameRateStatus2;

	ULONG	nFileSplittingSize2	= pScm->nFileSplittingSize2;
	ULONG	nFileSplittingTime2	= pScm->nFileSplittingTime2;
	ULONG	nFileSplittingStatus2 = pScm->nFileSplittingStatus2;

	ULONG	nRecordScale2 = pScm->nRecordScale2;

	if( nFileSplittingSize2 == 0 ) { nFileSplittingSize2 = 0; }
	if( nFileSplittingSize2 == 1 ) { nFileSplittingSize2 = 1024; }
	if( nFileSplittingSize2 == 2 ) { nFileSplittingSize2 = 1024*5; }
	if( nFileSplittingSize2 == 3 ) { nFileSplittingSize2 = 1024*10; }
	if( nFileSplittingSize2 == 4 ) { nFileSplittingSize2 = 1024*20; }
	if( nFileSplittingSize2 == 5 ) { nFileSplittingSize2 = 1024*40; }
	if( nFileSplittingSize2 == 6 ) { nFileSplittingSize2 = 1024*80; }
	if( nFileSplittingSize2 == 7 ) { nFileSplittingSize2 = 1024*160; }
	if( nFileSplittingSize2 == 8 ) { nFileSplittingSize2 = 1024*320; }

	if( nFileSplittingTime2 == 0 ) { nFileSplittingTime2 = 0; }
	if( nFileSplittingTime2 == 1 ) { nFileSplittingTime2 = 60; }
	if( nFileSplittingTime2 == 2 ) { nFileSplittingTime2 = 60*2; }
	if( nFileSplittingTime2 == 3 ) { nFileSplittingTime2 = 60*3; }
	if( nFileSplittingTime2 == 4 ) { nFileSplittingTime2 = 60*4; }
	if( nFileSplittingTime2 == 5 ) { nFileSplittingTime2 = 60*5; }
	if( nFileSplittingTime2 == 6 ) { nFileSplittingTime2 = 60*6; }
	if( nFileSplittingTime2 == 7 ) { nFileSplittingTime2 = 60*7; }
//
//
	for( ULONG i = 0; i < 4; i++ )
	{
		if( nPostFrameRateStatus == 0 ) {
			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pMainDlg->m_srtQcap[ i ].m_hVideoDevice, 0, pScm->nEncoderFormat, pScm->nRecordProfile, pScm->nRecordLevel, pScm->nRecordEntropy, pScm->nRecordMode, pScm->nQuality, pScm->nBitRate, pScm->nGOP, pScm->nBFrames, pScm->bIsInterleaved, 0, 0, 0, pScm->nAspectRatioX, pScm->nAspectRatioY, pScm->nCropX, pScm->nCropY, pScm->nCropW, pScm->nCropH, pScm->nRecordScale, pScm->nPostSkipFrameRate, 0 );
		}
		if( nPostFrameRateStatus == 1 ) {
			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pMainDlg->m_srtQcap[ i ].m_hVideoDevice, 0, pScm->nEncoderFormat, pScm->nRecordProfile, pScm->nRecordLevel, pScm->nRecordEntropy, pScm->nRecordMode, pScm->nQuality, pScm->nBitRate, pScm->nGOP, pScm->nBFrames, pScm->bIsInterleaved, 0, 0, 0, pScm->nAspectRatioX, pScm->nAspectRatioY, pScm->nCropX, pScm->nCropY, pScm->nCropW, pScm->nCropH, pScm->nRecordScale, 0, pScm->nPostAvgFrameRate );
		}
		if( nPostFrameRateStatus2 == 0 ){
			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pMainDlg->m_srtQcap[ i ].m_hVideoDevice, 1, pScm->nEncoderFormat2, pScm->nRecordProfile2, pScm->nRecordLevel2, pScm->nRecordEntropy2, pScm->nRecordMode2, pScm->nQuality2, pScm->nBitRate2, pScm->nGOP2, pScm->nBFrames2, pScm->bIsInterleaved2, 0, 0, 0, pScm->nAspectRatioX2, pScm->nAspectRatioY2, pScm->nCropX2, pScm->nCropY2, pScm->nCropW2, pScm->nCropH2, pScm->nRecordScale2, pScm->nPostSkipFrameRate2, 0 );
		}
		if( nPostFrameRateStatus2 == 1 ){
			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pMainDlg->m_srtQcap[ i ].m_hVideoDevice, 1, pScm->nEncoderFormat2, pScm->nRecordProfile2, pScm->nRecordLevel2, pScm->nRecordEntropy2, pScm->nRecordMode2, pScm->nQuality2, pScm->nBitRate2, pScm->nGOP2, pScm->nBFrames2, pScm->bIsInterleaved2, 0, 0, 0, pScm->nAspectRatioX2, pScm->nAspectRatioY2, pScm->nCropX2, pScm->nCropY2, pScm->nCropW2, pScm->nCropH2, pScm->nRecordScale2, 0, pScm->nPostAvgFrameRate2 );
		}
	}
//
//
//
	g_bRecordApply = 0;

	delete g_pPropertyDlg;
}

void CPropertyDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here

	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;
//
//	INITIALIZE SETUP PARAMS
//
	CHAR	sz[ MAX_PATH ] = {0};
	CHAR*	psz = sz;
	pMainDlg->GetAppPath( psz, MAX_PATH );
	lstrcpy( g_scmProtypeEx.pszRecordFilePathName, psz );
	m_editRecordPath = g_scmProtypeEx.pszRecordFilePathName;

	m_comboRecordEntropy.SetCurSel( 1 );		pScm->nRecordEntropy = 1;

	m_comboRecordMode.SetCurSel( 1 );			pScm->nRecordMode = 1;

	m_editRecordQuality = 8000;					pScm->nQuality = 8000;

	m_editRecordBitrate = 4000000;				pScm->nBitRate = 4000000;

	m_editRecordGop		= 30;					pScm->nGOP = 30;

	((CButton*)GetDlgItem( IDC_RADIO_SKIP ))->SetCheck( TRUE );	pScm->nPostFrameRateStatus = 0;
	((CButton*)GetDlgItem( IDC_RADIO_AVG ))->SetCheck( FALSE );

	((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE ))->SetCheck( TRUE ); pScm->nFileSplittingStatus = 0;
	((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME ))->SetCheck( FALSE );

	m_comboFileSize.SetCurSel( 0 ); pScm->nFileSplittingSize = 0;

	m_comboFileTime.SetCurSel( 0 ); pScm->nFileSplittingTime = 0;

	m_comboRecordSkipFrame.SetCurSel( 0 );		pScm->nPostSkipFrameRate = 0;

	m_comboRecordAvgFrame.SetCurSel( 25 );		pScm->nPostAvgFrameRate = 25;

	m_comboRecordScale.SetCurSel( 0 );			pScm->nRecordScale = 0;

//
//	SUB
//
	m_comboRecordEntropy2.SetCurSel( 1 );		pScm->nRecordEntropy2 = 1;

	m_comboRecordMode2.SetCurSel( 1 );			pScm->nRecordMode2 = 1;

	m_editRecordQuality2 = 8000;				pScm->nQuality2 = 8000;

	m_editRecordBitrate2 = 2000000;				pScm->nBitRate2 = 2000000;

	m_editRecordGop2	= 30;					pScm->nGOP2 = 30;

	((CButton*)GetDlgItem( IDC_RADIO_SKIP2 ))->SetCheck( TRUE );	pScm->nPostFrameRateStatus2 = 0;
	((CButton*)GetDlgItem( IDC_RADIO_AVG2 ))->SetCheck( FALSE );

	((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE2 ))->SetCheck( TRUE ); pScm->nFileSplittingStatus2= 0;
	((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME2 ))->SetCheck( FALSE );

	m_comboFileSize2.SetCurSel( 0 ); pScm->nFileSplittingSize2 = 0;

	m_comboFileTime2.SetCurSel( 0 ); pScm->nFileSplittingTime2 = 0;

	m_comboRecordSkipFrame2.SetCurSel( 0 );		pScm->nPostSkipFrameRate2 = 0;

	m_comboRecordAvgFrame2.SetCurSel( 25 );		pScm->nPostAvgFrameRate2 = 25;

	m_comboRecordScale2.SetCurSel( 0 );			pScm->nRecordScale2 = 0;

	UpdateData(FALSE);
}

BOOL CPropertyDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CSC3B0Dlg * pMainDlg = CSC3B0Dlg::s_pMainDlg;

	STRUCT_SRPEX *pScm = &g_scmProtypeEx;

	m_editRecordPath =  pScm->pszRecordFilePathName;

	m_comboEncodeType.AddString( _T("HARDWARE") );
	m_comboEncodeType.SetCurSel( 0 );

	m_comboRecorFormat.AddString( _T("H264") );
	m_comboRecorFormat.SetCurSel( 0 );

	m_comboRecordProfile.AddString(_T("BASELINE"));
	m_comboRecordProfile.SetCurSel( 0 );

	m_comboRecordSkipFrame.AddString( _T("0") );
	m_comboRecordSkipFrame.AddString( _T("1/2") );
	m_comboRecordSkipFrame.AddString( _T("1/3") );
	m_comboRecordSkipFrame.AddString( _T("1/4") );
	m_comboRecordSkipFrame.AddString( _T("1/5") );
	m_comboRecordSkipFrame.AddString( _T("1/6") );
	m_comboRecordSkipFrame.AddString( _T("1/7") );
	m_comboRecordSkipFrame.SetCurSel( pScm->nPostSkipFrameRate );

	CHAR sz[ 250 ] = { 0 };
	ULONG pos = 0;
	ULONG nStandard = ( DEFAULT_STANDARD )? 25: 30 ;
	pScm->nPostAvgFrameRate = nStandard;
	for( ULONG i = 0; i < nStandard+1; i++ )
	{	
		sprintf( sz, "%d", i );
		pos = m_comboRecordAvgFrame.AddString( sz );
		m_comboRecordAvgFrame.SetItemData( pos, i);
		if( pScm->nPostAvgFrameRate == i ) {
			m_comboRecordAvgFrame.SetCurSel( i ); }
	}

	m_comboRecordEntropy.AddString(_T("CAVLC"));
	m_comboRecordEntropy.SetCurSel( pScm->nRecordEntropy );

	m_comboRecordMode.AddString(_T("VBR"));
	m_comboRecordMode.AddString(_T("CBR"));
	m_comboRecordMode.AddString(_T("ABR"));
	m_comboRecordMode.SetCurSel( pScm->nRecordMode );

	m_editRecordQuality = pScm->nQuality;

	m_editRecordBitrate = pScm->nBitRate;

	m_editRecordGop		= pScm->nGOP;

	m_comboFileTime.AddString( _T("NONE") );
	m_comboFileTime.AddString( _T("60 SEC") );
	m_comboFileTime.AddString( _T("120 SEC") );
	m_comboFileTime.AddString( _T("180 SEC") );
	m_comboFileTime.AddString( _T("240 SEC") );
	m_comboFileTime.AddString( _T("300 SEC") );
	m_comboFileTime.AddString( _T("360 SEC") );
	m_comboFileTime.AddString( _T("420 SEC") );
	m_comboFileTime.SetCurSel( pScm->nFileSplittingTime );

	m_comboFileSize.AddString( _T("NONE") );
	m_comboFileSize.AddString( _T("1 MB") );
	m_comboFileSize.AddString( _T("5 MB") );
	m_comboFileSize.AddString( _T("10 MB") );
	m_comboFileSize.AddString( _T("20 MB") );
	m_comboFileSize.AddString( _T("40 MB") );
	m_comboFileSize.AddString( _T("80 MB") );
	m_comboFileSize.AddString( _T("160 MB") );
	m_comboFileSize.SetCurSel( pScm->nFileSplittingSize );

	m_comboRecordScale.AddString( _T("0") );
	m_comboRecordScale.AddString( _T("1/2") );
	m_comboRecordScale.SetCurSel( pScm->nRecordScale );
//
//	SUB
//
	m_comboEncodeType2.AddString( _T("HARDWARE") );
	m_comboEncodeType2.SetCurSel( 0 );

	m_comboRecorFormat2.AddString( _T("H264") );
	m_comboRecorFormat2.SetCurSel( 0 );

	m_comboRecordProfile2.AddString(_T("BASELINE"));
	m_comboRecordProfile2.SetCurSel( 0 );

	m_comboRecordSkipFrame2.AddString( _T("0") );
	m_comboRecordSkipFrame2.AddString( _T("1/2") );
	m_comboRecordSkipFrame2.AddString( _T("1/3") );
	m_comboRecordSkipFrame2.AddString( _T("1/4") );
	m_comboRecordSkipFrame2.AddString( _T("1/5") );
	m_comboRecordSkipFrame2.AddString( _T("1/6") );
	m_comboRecordSkipFrame2.AddString( _T("1/7") );
	m_comboRecordSkipFrame2.SetCurSel( pScm->nPostSkipFrameRate2 );

	CHAR sz2[ 250 ] = { 0 };
	ULONG pos2 = 0;
	ULONG nStandard2 = ( DEFAULT_STANDARD )? 25: 30 ;
	pScm->nPostAvgFrameRate2 = nStandard2;
	for( ULONG i2 = 0; i2 < nStandard2+1; i2++ )
	{	
		sprintf( sz2, "%d", i2 );
		pos2 = m_comboRecordAvgFrame2.AddString( sz2 );
		m_comboRecordAvgFrame2.SetItemData( pos2, i2);
		if( pScm->nPostAvgFrameRate2 == i2 ) {
			m_comboRecordAvgFrame2.SetCurSel( i2 ); }
	}

	m_comboRecordEntropy2.AddString(_T("CAVLC"));
	m_comboRecordEntropy2.SetCurSel( pScm->nRecordEntropy2 );

	m_comboRecordMode2.AddString(_T("VBR"));
	m_comboRecordMode2.AddString(_T("CBR"));
	m_comboRecordMode2.AddString(_T("ABR"));
	m_comboRecordMode2.SetCurSel( pScm->nRecordMode2 );

	m_editRecordQuality2 = pScm->nQuality2;

	m_editRecordBitrate2 = pScm->nBitRate2;

	m_editRecordGop2		= pScm->nGOP2;

	m_comboFileTime2.AddString( _T("NONE") );
	m_comboFileTime2.AddString( _T("60 SEC") );
	m_comboFileTime2.AddString( _T("120 SEC") );
	m_comboFileTime2.AddString( _T("180 SEC") );
	m_comboFileTime2.AddString( _T("240 SEC") );
	m_comboFileTime2.AddString( _T("300 SEC") );
	m_comboFileTime2.AddString( _T("360 SEC") );
	m_comboFileTime2.AddString( _T("420 SEC") );
	m_comboFileTime2.SetCurSel( pScm->nFileSplittingTime2 );

	m_comboFileSize2.AddString( _T("NONE") );
	m_comboFileSize2.AddString( _T("1 MB") );
	m_comboFileSize2.AddString( _T("5 MB") );
	m_comboFileSize2.AddString( _T("10 MB") );
	m_comboFileSize2.AddString( _T("20 MB") );
	m_comboFileSize2.AddString( _T("40 MB") );
	m_comboFileSize2.AddString( _T("80 MB") );
	m_comboFileSize2.AddString( _T("160 MB") );
	m_comboFileSize2.SetCurSel( pScm->nFileSplittingSize2 );

	m_comboRecordScale2.AddString( _T("0") );
	m_comboRecordScale2.SetCurSel( pScm->nRecordScale2 );

	UpdateData( FALSE );

	if( pScm->nPostFrameRateStatus == 0 ) { ((CButton*)GetDlgItem( IDC_RADIO_SKIP ))->SetCheck( TRUE ); }
	if( pScm->nPostFrameRateStatus == 1 ) { ((CButton*)GetDlgItem( IDC_RADIO_AVG ))->SetCheck( TRUE ); }

	if( pScm->nFileSplittingStatus == 0 ) { ((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE ))->SetCheck( TRUE ); }
	if( pScm->nFileSplittingStatus == 1 ) { ((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME))->SetCheck( TRUE ); }
//
//	SUB
//	
	if( pScm->nPostFrameRateStatus2 == 0 ) { ((CButton*)GetDlgItem( IDC_RADIO_SKIP2 ))->SetCheck( TRUE ); }
	if( pScm->nPostFrameRateStatus2 == 1 ) { ((CButton*)GetDlgItem( IDC_RADIO_AVG2 ))->SetCheck( TRUE ); }

	if( pScm->nFileSplittingStatus2 == 0 ) { ((CButton*)GetDlgItem( IDC_RADIO_FILE_SIZE2 ))->SetCheck( TRUE ); }
	if( pScm->nFileSplittingStatus2 == 1 ) { ((CButton*)GetDlgItem( IDC_RADIO_FILE_TIME2))->SetCheck( TRUE ); }


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropertyDlg::OnDestroy() 
{
	CDialog::OnDestroy();
}

BOOL CPropertyDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class

	return CDialog::DestroyWindow();
}

void CPropertyDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	g_bRecordApply = 0;

	delete g_pPropertyDlg;
}
