#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include "sharerecorddlg.h"
#include "ui_sharerecorddlg.h"
#include "channelwindow.h"

#include "QCAP.H"

ShareRecordDlg::ShareRecordDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ShareRecordDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("SHARE RECORD DIALOG");

    this->setMinimumSize(663,214);

    this->setMaximumSize(663,214);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    ui->BTN_StopShareRecord->setEnabled(false);

    ui->BTN_StartShareRecord->setEnabled(false);

    ui->checkBox_SR_GPU->setChecked(true);

    ui->checkBox_SR_MP4->setChecked(true);

    ui->checkBox_SR_AVI->setChecked(false);

    ui->lineEdit_SR_Path->setText( SC510dlg->path + QString("/ShareRecord.mp4"));

    if( SC510dlg->m_hVideoDevice[0] || SC510dlg->m_hVideoDevice[1] || SC510dlg->m_hVideoDevice[2] || SC510dlg->m_hVideoDevice[3])
    {
        ui->BTN_StartShareRecord->setEnabled(true);
    }

    if( SC510dlg->m_hVideoDevice[0] == 0)
    {
        ui->radioButton_CH1->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[1] == 0)
    {
        ui->radioButton_CH2->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[2] == 0)
    {
        ui->radioButton_CH3->setEnabled(false);
    }

    if( SC510dlg->m_hVideoDevice[3] == 0)
    {
        ui->radioButton_CH4->setEnabled(false);
    }
}

ShareRecordDlg::~ShareRecordDlg()
{
    delete ui;
}

void ShareRecordDlg::on_checkBox_SR_AVI_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_SR_MP4->setChecked(true);

        ui->lineEdit_SR_Path->setText( SC510dlg->path + QString("/ShareRecord.mp4"));
    }
    else
    {
        ui->checkBox_SR_MP4->setChecked(false);

        ui->lineEdit_SR_Path->setText( SC510dlg->path + QString("/ShareRecord.avi"));
    }
}

void ShareRecordDlg::on_checkBox_SR_MP4_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0)
    {
        ui->checkBox_SR_AVI->setChecked(true);

        ui->lineEdit_SR_Path->setText( SC510dlg->path + QString("/ShareRecord.avi"));
    }
    else
    {
        ui->checkBox_SR_AVI->setChecked(false);

        ui->lineEdit_SR_Path->setText( SC510dlg->path + QString("/ShareRecord.mp4"));
    }
}

void ShareRecordDlg::on_BTN_StartShareRecord_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    nChannelNum = -1;

    if( ui->radioButton_CH1->isChecked() ) { nChannelNum = 0; }

    if( ui->radioButton_CH2->isChecked() ) { nChannelNum = 1; }

    if( ui->radioButton_CH3->isChecked() ) { nChannelNum = 2; }

    if( ui->radioButton_CH4->isChecked() ) { nChannelNum = 3; }

    if( nChannelNum == -1) { return; }

    qDebug("%d, %d, %d, %d, %d", SC510dlg->m_bShareRecordCH[ 0 ], SC510dlg->m_bShareRecordCH[ 1 ], SC510dlg->m_bShareRecordCH[ 2 ], SC510dlg->m_bShareRecordCH[ 3 ], nChannelNum);

    if( ui->checkBox_SR_AVI->isChecked() )
    {
        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, SC510dlg->m_nAudioChannels[nChannelNum], SC510dlg->m_nAudioBitsPerSample[nChannelNum], SC510dlg->m_nAudioSampleFrequency[nChannelNum], 100 );
    }
    else
    {
        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, SC510dlg->m_nAudioChannels[nChannelNum], SC510dlg->m_nAudioBitsPerSample[nChannelNum], SC510dlg->m_nAudioSampleFrequency[nChannelNum], 100 );
    }

    if( ui->checkBox_SR_GPU->isChecked() )
    {
        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, SC510dlg->m_nVideoWidth[nChannelNum], SC510dlg->m_nVideoHeight[nChannelNum], SC510dlg->m_dVideoFrameRate[nChannelNum], QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, (HWND)ui->m_DisplayWindow->winId(), 1 );
    }
    else
    {
        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, SC510dlg->m_nVideoWidth[nChannelNum], SC510dlg->m_nVideoHeight[nChannelNum], SC510dlg->m_dVideoFrameRate[nChannelNum], QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, (HWND)ui->m_DisplayWindow->winId(), 1 );
    }

    QByteArray record1_path_ByteArray = ui->lineEdit_SR_Path->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    QCAP_START_SHARE_RECORD(0, psz);

    SC510dlg->m_bIsShareRecord = TRUE;

    ui->BTN_StartShareRecord->setEnabled(false);

    ui->BTN_StopShareRecord->setEnabled(true);
}

void ShareRecordDlg::on_BTN_StopShareRecord_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_bIsShareRecord == TRUE )
    {
        QCAP_STOP_SHARE_RECORD( 0 );

        SC510dlg->m_bIsShareRecord = FALSE;

        ui->BTN_StartShareRecord->setEnabled(true);

        ui->BTN_StopShareRecord->setEnabled(false);
    }
}

void ShareRecordDlg::on_radioButton_CH1_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    nChannelNum = 0;

    SC510dlg->m_bShareRecordCH[ 0 ] = TRUE;

    SC510dlg->m_bShareRecordCH[ 1 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 2 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 3 ] = FALSE;
}

void ShareRecordDlg::on_radioButton_CH2_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    nChannelNum = 1;

    SC510dlg->m_bShareRecordCH[ 0 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 1 ] = TRUE;

    SC510dlg->m_bShareRecordCH[ 2 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 3 ] = FALSE;
}

void ShareRecordDlg::on_radioButton_CH3_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    nChannelNum = 2;

    SC510dlg->m_bShareRecordCH[ 0 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 1 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 2 ] = TRUE;

    SC510dlg->m_bShareRecordCH[ 3 ] = FALSE;
}

void ShareRecordDlg::on_radioButton_CH4_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    nChannelNum = 3;

    SC510dlg->m_bShareRecordCH[ 0 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 1 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 2 ] = FALSE;

    SC510dlg->m_bShareRecordCH[ 3 ] = TRUE;
}

void ShareRecordDlg::closeEvent ( QCloseEvent * e )
{
    on_BTN_StopShareRecord_clicked();
}
