#include "videoqualitydlg.h"
#include "ui_videoqualitydlg.h"
#include "channelwindow.h"

#include "QCAP.H"

VideoQualityDlg::VideoQualityDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::VideoQualityDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("VIDEO QUALITY");

    this->setMinimumSize(460,300);

    this->setMaximumSize(460,300);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    ULONG BRIGHTNESS, CONSTRAST, HUE, SATURATION, SHARPNESS;

    //BRIGHTNESS
    ui->Slider_BRIGHTNESS->setRange(0,255);

    QCAP_GET_VIDEO_BRIGHTNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], &BRIGHTNESS );

    ui->Slider_BRIGHTNESS->setValue( (int)BRIGHTNESS );

    //CONSTRAST
    ui->Slider_CONSTRAST->setRange(0,255);

    QCAP_GET_VIDEO_CONTRAST( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], &CONSTRAST);

    ui->Slider_CONSTRAST->setValue( (int)CONSTRAST );

    //HUE
    ui->Slider_HUE->setRange(0,255);

    QCAP_GET_VIDEO_HUE( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], &HUE);

    ui->Slider_HUE->setValue( (int)HUE );

    //SATURATION
    ui->Slider_SATURATION->setRange(0,255);

    QCAP_GET_VIDEO_SATURATION( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], &SATURATION);

    ui->Slider_SATURATION->setValue( (int)SATURATION );

    //SHARPNESS
    ui->Slider_SHARPNESS->setRange(0,255);

    QCAP_GET_VIDEO_SHARPNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], &SHARPNESS);

    ui->Slider_SHARPNESS->setValue( (int)SHARPNESS );
}

VideoQualityDlg::~VideoQualityDlg()
{
    delete ui;
}

void VideoQualityDlg::on_pushButton_ok_clicked()
{
    this->close();
}

void VideoQualityDlg::on_pushButton_DEFAULT_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow] != 0 )
    {
        QCAP_SET_VIDEO_BRIGHTNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], 128 );

        QCAP_SET_VIDEO_CONTRAST( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], 128 );

        QCAP_SET_VIDEO_HUE( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], 128 );

        QCAP_SET_VIDEO_SATURATION( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], 128 );

        QCAP_SET_VIDEO_SHARPNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], 128 );
    }
}

void VideoQualityDlg::on_Slider_BRIGHTNESS_valueChanged(int value)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    QCAP_SET_VIDEO_BRIGHTNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], value );

    QString str_BRIGHTNESS;

    str_BRIGHTNESS.sprintf("%d",value);

    ui->label_BRIGHTNESS->setText(str_BRIGHTNESS);
}

void VideoQualityDlg::on_Slider_CONSTRAST_valueChanged(int value)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    QCAP_SET_VIDEO_CONTRAST( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], value );

    QString str_CONSTRAST;

    str_CONSTRAST.sprintf("%d",value);

    ui->label_CONSTRAST->setText(str_CONSTRAST);
}

void VideoQualityDlg::on_Slider_HUE_valueChanged(int value)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    QCAP_SET_VIDEO_HUE( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], value );

    QString str_HUE;

    str_HUE.sprintf("%d",value);

    ui->label_HUE->setText(str_HUE);
}

void VideoQualityDlg::on_Slider_SATURATION_valueChanged(int value)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    QCAP_SET_VIDEO_SATURATION( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], value );

    QString str_SATURATION;

    str_SATURATION.sprintf("%d",value);

    ui->label_SATURATION->setText(str_SATURATION);
}

void VideoQualityDlg::on_Slider_SHARPNESS_valueChanged(int value)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    QCAP_SET_VIDEO_SHARPNESS( SC510dlg->m_hVideoDevice[SC510dlg->m_nChannelWindow], value );

    QString str_SHARPNESS;

    str_SHARPNESS.sprintf("%d",value);

    ui->label_SHARPNESS->setText(str_SHARPNESS);
}
