#include "LINUXXWIN.h"
#include "ah8400.h"

// ##############################################################################################################################################################################
// #
// # PRODUCT NAME: LINUXXWIN
// #        CHIPS: NONE
// #  MANUFACTORY: YUAN
// #         DATE: 2009.09.20 ~ 2009.12.31
// #      CONTACT: huengpei@yuan.com.tw, 23921233 - 254, 0911291010
// #
// ##############################################################################################################################################################################
//

BOOLEAN XWINDOW_CREATE( CXWindow * pXWindow, ULONG nWindowPosX, ULONG nWindowPosY, ULONG nWindowWidth, ULONG nWindowHeight, ULONG nWindowBorder, CHAR * pszWindowTitleName );

BOOLEAN XWINDOW_DESTROY( CXWindow * pXWindow );

BOOLEAN XVIDEO_CREATE( CXWindow * pXWindow, ULONG nVideoColorSpace, ULONG nVideoWidth, ULONG nVideoHeight );

BOOLEAN XVIDEO_DESTROY( CXWindow * pXWindow );

BOOLEAN V4L2_CREATE( CDevice * pDevice, CHAR * pszDeviceName, ULONG nVideoColorSpace, ULONG nVideoWidth, ULONG nVideoHeight, CXWindow * pXWindow );

BOOLEAN V4L2_DESTROY( CDevice * pDevice );

BOOLEAN V4L2_START( CDevice * pDevice );

BOOLEAN V4L2_STOP( CDevice * pDevice );


int SplitNumber = 1;

int width, height;


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// XWINDOW PROGRAMMING GUIDE
// 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
BOOLEAN XWINDOW_CREATE( CXWindow * pXWindow, ULONG nWindowPosX, ULONG nWindowPosY, ULONG nWindowWidth, ULONG nWindowHeight, ULONG nWindowBorder, CHAR * pszWindowTitleName )
{
	// CREATE DISPLAY RESOURCES
	// 
	{	Display * pDisplay = XOpenDisplay( NULL );

		if( pDisplay == NULL ) { goto XWINDOW_CREATE_FAILED; }

		pXWindow->m_nDisplayScreen = XDefaultScreen( pDisplay );

		pXWindow->m_nDisplayWidth = XDisplayWidth( pDisplay, pXWindow->m_nDisplayScreen ); // EX: 1024

		pXWindow->m_nDisplayHeight = XDisplayHeight( pDisplay, pXWindow->m_nDisplayScreen ); // EX: 768

		pXWindow->m_nDisplayDepth = XDefaultDepth( pDisplay, pXWindow->m_nDisplayScreen ); // EX: 24

		pXWindow->m_pDisplay = pDisplay;

		LINUXXWIN_DEBUG( "[%08X] XWINDOW_CREATE( DISPALY = %08X, SCREEN = %d, WIDTH = %d, HEIGHT = %d, DEPTH = %d ) (1)\n", (unsigned int)pXWindow, (unsigned int)pXWindow->m_pDisplay, (unsigned int)pXWindow->m_nDisplayScreen, (int)pXWindow->m_nDisplayWidth, (int)pXWindow->m_nDisplayHeight, (int)pXWindow->m_nDisplayDepth );
	}
	// CREATE XWINDOW RESOURCES
	//
	{	XSetWindowAttributes s_set_window_attributes;

		Window hWindow = XCreateWindow( pXWindow->m_pDisplay, 

										XDefaultRootWindow( pXWindow->m_pDisplay ),

										nWindowPosX,
										
										nWindowPosY,
										
										nWindowWidth,
										
										nWindowHeight,
										
										nWindowBorder,
										
										XDefaultDepth( pXWindow->m_pDisplay, pXWindow->m_nDisplayScreen ),
										
										InputOutput,
										
										DefaultVisual( pXWindow->m_pDisplay, pXWindow->m_nDisplayScreen ),
										
										0,

									   &s_set_window_attributes ); // http://tronche.com/gui/x/xlib/window/XCreateWindow.html

		if( hWindow == 0x00000000 ) { goto XWINDOW_CREATE_FAILED; }

		pXWindow->m_hWindow = hWindow;

		XStoreName( pXWindow->m_pDisplay, pXWindow->m_hWindow, pszWindowTitleName );

		XMapWindow( pXWindow->m_pDisplay, pXWindow->m_hWindow );

		XFlush( pXWindow->m_pDisplay );

		LINUXXWIN_DEBUG( "[%08X] XWINDOW_CREATE( WINDOW = %08X ) (2)\n", (unsigned int)pXWindow, (unsigned int)pXWindow->m_hWindow );
	}

	LINUXXWIN_DEBUG( "[%08X] XWINDOW_CREATE( SUCCESS )\n", (unsigned int)pXWindow );

	return TRUE;

XWINDOW_CREATE_FAILED:

	// DESTROY XWINDOW RESOURCES
	//
	if( pXWindow->m_hWindow ) {
		
		XDestroyWindow( pXWindow->m_pDisplay, pXWindow->m_hWindow ); 

		XFlush( pXWindow->m_pDisplay ); 

		pXWindow->m_hWindow = 0x00000000;
	}
	// DESTROY DISPLAY RESOURCES
	//
	if( pXWindow->m_pDisplay ) {

		XCloseDisplay( pXWindow->m_pDisplay ); 

		pXWindow->m_nDisplayScreen = 0;

		pXWindow->m_nDisplayWidth = 0;

		pXWindow->m_nDisplayHeight = 0;

		pXWindow->m_nDisplayDepth = 0;

		pXWindow->m_pDisplay = NULL;
	}
	return FALSE;
}

BOOLEAN XWINDOW_DESTROY( CXWindow * pXWindow )
{
	if( pXWindow ) { 

		// DESTROY XWINDOW RESOURCES
		//
		if( pXWindow->m_hWindow ) {
			
			XDestroyWindow( pXWindow->m_pDisplay, pXWindow->m_hWindow ); 

			XFlush( pXWindow->m_pDisplay );

			pXWindow->m_hWindow = 0x00000000;
		}
		// DESTROY DISPLAY RESOURCES
		//
		if( pXWindow->m_pDisplay ) {

			XCloseDisplay( pXWindow->m_pDisplay ); 

			pXWindow->m_nDisplayScreen = 0;

			pXWindow->m_nDisplayWidth = 0;

			pXWindow->m_nDisplayHeight = 0;

			pXWindow->m_nDisplayDepth = 0;

			pXWindow->m_pDisplay = NULL;
		}
	}

	LINUXXWIN_DEBUG( "[%08X] XWINDOW_DESTROY( SUCCESS )\n", (unsigned int)pXWindow );

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// XVIDEO.EXTENSION PROGRAMMING GUIDE
// 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
BOOLEAN XVIDEO_CREATE( CXWindow * pXWindow, DWORD nVideoColorSpace, ULONG nVideoWidth, ULONG nVideoHeight )
{
	// CREATE XVIDEO.EXTENSION RESOURCES
	// 
	{	unsigned int n_xv_version = 0;

		unsigned int n_xv_release = 0;

		unsigned int n_xv_request_base = 0;

		unsigned int n_xv_event_base = 0;

		unsigned int n_xv_error_base = 0;

		unsigned int n_xv_num_adaptors = 0;

		XvAdaptorInfo * p_xv_adaptor_info = NULL;

		unsigned int i = 0;

		if( XvQueryExtension( pXWindow->m_pDisplay, &n_xv_version, &n_xv_release, &n_xv_request_base, &n_xv_event_base, &n_xv_error_base ) == Success ) {

			LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( VERSION = %08X, RELEASE = %08X, BASE = %08X/%08X/%08X ) (1)\n", (unsigned int)pXWindow, n_xv_version, n_xv_release, n_xv_request_base, n_xv_event_base, n_xv_error_base );
		}
		if( XvQueryAdaptors( pXWindow->m_pDisplay, XDefaultRootWindow( pXWindow->m_pDisplay ), &n_xv_num_adaptors, &p_xv_adaptor_info ) == Success ) {

			LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( NUM.ADAPTOR = %d ) (1)\n", (unsigned int)pXWindow, n_xv_num_adaptors );
		}
		for( i = 0; i < n_xv_num_adaptors ; i++ ) {

			unsigned int n_xv_num_attributes = 0;

			unsigned int n_xv_num_formats = 0;

			unsigned int j = 0;

			XvAttribute * p_xv_attribute = NULL;

			XvImageFormatValues * p_xv_image_format_values = NULL;

			p_xv_attribute = XvQueryPortAttributes( pXWindow->m_pDisplay, p_xv_adaptor_info[ i ].base_id, &n_xv_num_attributes );

			for( j = 0 ; j < n_xv_num_attributes ; j++ ) {

				LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( ADAPTOR = %d, ATTRIBUTE = %s ) (1)\n", (unsigned int)pXWindow, i, p_xv_attribute[ j ].name );
			}
			p_xv_image_format_values = XvListImageFormats( pXWindow->m_pDisplay, p_xv_adaptor_info[ i ].base_id, &n_xv_num_formats );

			for( j = 0 ; j < n_xv_num_formats ; j++ ) {

				CHAR psz[ 5 ] = { 0x00, 0x00, 0x00, 0x00 };

				memcpy( psz, &(p_xv_image_format_values[ j ].id), 4 );

				LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( ADAPTOR = %d, FORMAT = %s ) (1)\n", (unsigned int)pXWindow, i, psz );
			}
			if( p_xv_attribute ) {

				XFree( p_xv_attribute );

				p_xv_attribute = NULL;	
			}
			if( p_xv_image_format_values ) {

				XFree( p_xv_image_format_values );

				p_xv_image_format_values = NULL;
			}
		}
		if( p_xv_adaptor_info ) { pXWindow->m_nXvAdaptorPortID = p_xv_adaptor_info[ 0 ].base_id; } // DEFAULT = 0

		if( p_xv_adaptor_info ) {
			
			XvFreeAdaptorInfo( p_xv_adaptor_info );

			p_xv_adaptor_info = NULL;
		}
		pXWindow->m_nXvImageColorSpace = nVideoColorSpace;

		pXWindow->m_nXvImageWidth = nVideoWidth;

		pXWindow->m_nXvImageHeight = nVideoHeight;

		pXWindow->m_nXvImageDepth = 0;

		if( pXWindow->m_nXvImageColorSpace == 0x32595559 ) { pXWindow->m_nXvImageDepth = 16; } // YUYV

		if( pXWindow->m_nXvImageColorSpace == 0x59565955 ) { pXWindow->m_nXvImageDepth = 16; } // UYVY

		if( pXWindow->m_nXvImageDepth == 0 ) { goto XVIDEO_CREATE_FAILED; } // UNSUPPORT FORMATS

		pXWindow->m_pXvImageBuffer = (BYTE *)(malloc( pXWindow->m_nXvImageWidth * pXWindow->m_nXvImageHeight * pXWindow->m_nXvImageDepth / 8 ));
	
		if( pXWindow->m_pXvImageBuffer == NULL ) { goto XVIDEO_CREATE_FAILED; }

		pXWindow->m_pXvImage = XvCreateImage( pXWindow->m_pDisplay, 

											  pXWindow->m_nXvAdaptorPortID, 

											  pXWindow->m_nXvImageColorSpace,

											  pXWindow->m_pXvImageBuffer, 

											  pXWindow->m_nXvImageWidth, 

											  pXWindow->m_nXvImageHeight );

		if( pXWindow->m_pXvImage == NULL ) { goto XVIDEO_CREATE_FAILED; }

		LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( IMAGE = %08X ) (1)\n", (unsigned int)pXWindow, (unsigned int)pXWindow->m_pXvImage );
	}
	LINUXXWIN_DEBUG( "[%08X] XVIDEO_CREATE( SUCCESS )\n", (unsigned int)pXWindow );

	return TRUE;

XVIDEO_CREATE_FAILED:

	// DESTROY XVIDEO.EXTENSION RESOURCES
	//
	if( pXWindow->m_pXvImage ) {

		XFree( pXWindow->m_pXvImage );

		pXWindow->m_pXvImage = NULL;
	}
	if( pXWindow->m_pXvImageBuffer ) {

		free( pXWindow->m_pXvImageBuffer );

		pXWindow->m_pXvImageBuffer = NULL;
	}
}

BOOLEAN XVIDEO_DESTROY( CXWindow * pXWindow )
{
	// DESTROY XVIDEO.EXTENSION RESOURCES
	//
	if( pXWindow->m_pXvImage ) {

		XFree( pXWindow->m_pXvImage );

		pXWindow->m_pXvImage = NULL;
	}
	if( pXWindow->m_pXvImageBuffer ) {

		free( pXWindow->m_pXvImageBuffer );

		pXWindow->m_pXvImageBuffer = NULL;
	}
	LINUXXWIN_DEBUG( "[%08X] XVIDEO_DESTROY( SUCCESS )\n", (unsigned int)pXWindow );

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// V4L2 PROGRAMMING GUIDE
// 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
BOOLEAN V4L2_IOCTL( CDevice * pDevice, DWORD dwRequest, VOID * pArgument )
{
	int returns = -1;

	do {
		
		returns = ioctl( pDevice->m_hHwDevice, dwRequest, pArgument );

	} while( (-1 == returns) && (EINTR == errno) );

	return (returns == -1) ? FALSE : TRUE;
}

BOOLEAN V4L2_CREATE( CDevice * pDevice, CHAR * pszDeviceName, ULONG nVideoColorSpace, ULONG nVideoWidth, ULONG nVideoHeight, CXWindow * pXWindow )
{
	// CREATE DEVICE RESOURCES
	// 
	{	struct stat status; 

		int hDev = -1;

		memset( &status, 0x00, sizeof(stat) );

		if( -1 == stat( pszDeviceName, &status ) ) { return FALSE; } // CHECK THE DEVICE'S STATUS

		if( FALSE == S_ISCHR(status.st_mode) ) { return FALSE; } // CHECK IF THE DEVIEC IS ONE CHARACTER DEVICE

		hDev = open( pszDeviceName, O_RDWR, 0 );

		if( hDev == -1 ) { return FALSE; }

		pDevice->m_pXWindow = pXWindow;

		pDevice->m_hHwDevice = hDev;

		pDevice->m_nVideoBufferSize = 0;

		pDevice->m_sVideoBuffer = NULL;

		LINUXXWIN_DEBUG( "[%08X] V4L2_CREATE( DEVICE = %08X ) (1)\n", (unsigned int)pDevice, pDevice->m_hHwDevice );
	}
	// INITIALIZE DEVICE
	//
	{	struct v4l2_capability s_v4l2_capability;

		struct v4l2_format s_v4l2_format;

		struct v4l2_requestbuffers s_v4l2_requestbuffers;

		struct v4l2_buffer s_v4l2_buffer;

		int i = 0;

		memset( &s_v4l2_capability, 0x00, sizeof(struct v4l2_capability) );

		memset( &s_v4l2_format, 0x00, sizeof(struct v4l2_format) );

		memset( &s_v4l2_requestbuffers, 0x00, sizeof(struct v4l2_requestbuffers) );

		memset( &s_v4l2_buffer, 0x00, sizeof(struct v4l2_buffer) );

		// VIDIOC_QUERYCAP
		//
		if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_QUERYCAP, &s_v4l2_capability ) ) { goto V4L2_CREATE_FAILED; }

		if( 0x00000000 == (s_v4l2_capability.capabilities & V4L2_CAP_VIDEO_CAPTURE) ) { goto V4L2_CREATE_FAILED; }

		if( 0x00000000 == (s_v4l2_capability.capabilities & V4L2_CAP_STREAMING) ) { goto V4L2_CREATE_FAILED; }

		LINUXXWIN_DEBUG( "[%08X] V4L2_CREATE( CAPABILITY = %08X ) (2)\n", (unsigned int)pDevice, s_v4l2_capability.capabilities);

		// VIDIOC_S_FMT
		//
		s_v4l2_format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

		s_v4l2_format.fmt.pix.pixelformat = 0x00000000;

		if( nVideoColorSpace == 0x32595559 ) { s_v4l2_format.fmt.pix.pixelformat = V4L2_PIX_FMT_YUYV; }

		if( nVideoColorSpace == 0x59565955 ) { s_v4l2_format.fmt.pix.pixelformat = V4L2_PIX_FMT_UYVY; }

		if( s_v4l2_format.fmt.pix.pixelformat == 0x00000000 ) { goto V4L2_CREATE_FAILED; } // UNSUPPORT FORMATS

		s_v4l2_format.fmt.pix.width = nVideoWidth;

		s_v4l2_format.fmt.pix.height = nVideoHeight;

		s_v4l2_format.fmt.pix.field = V4L2_FIELD_INTERLACED;

		if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_S_FMT, &s_v4l2_format ) ) { goto V4L2_CREATE_FAILED; }

		LINUXXWIN_DEBUG( "[%08X] V4L2_CREATE( COLORSPACE = %08X, WIDTH = %d, HEIGHT = %d ) (2)\n", (unsigned int)pDevice, s_v4l2_format.fmt.pix.pixelformat, s_v4l2_format.fmt.pix.width, s_v4l2_format.fmt.pix.height );

		// VIDIOC_REQBUFS / VIDIOC_QUERYBUF
		//
		s_v4l2_requestbuffers.count = 8;

		s_v4l2_requestbuffers.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

		s_v4l2_requestbuffers.memory = V4L2_MEMORY_MMAP;

		if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_REQBUFS, &s_v4l2_requestbuffers ) ) { goto V4L2_CREATE_FAILED; }

		if( s_v4l2_requestbuffers.count < 2 ) { goto V4L2_CREATE_FAILED; }

		pDevice->m_nVideoBufferSize = s_v4l2_requestbuffers.count;

		pDevice->m_sVideoBuffer = calloc( pDevice->m_nVideoBufferSize, sizeof(struct CVideoBuffer) );

		for( i = 0; i < pDevice->m_nVideoBufferSize ; i++ ) {

			s_v4l2_buffer.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

			s_v4l2_buffer.memory = V4L2_MEMORY_MMAP;

			s_v4l2_buffer.index = i;

			if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_QUERYBUF, &s_v4l2_buffer ) ) { goto V4L2_CREATE_FAILED; }

			pDevice->m_sVideoBuffer[ i ].m_nKsBufferSize = s_v4l2_buffer.length;

			pDevice->m_sVideoBuffer[ i ].m_pKsBuffer = mmap( NULL, s_v4l2_buffer.length, PROT_READ | PROT_WRITE, MAP_SHARED, pDevice->m_hHwDevice, s_v4l2_buffer.m.offset );

			if( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer == MAP_FAILED ) { goto V4L2_CREATE_FAILED; }
		}
		LINUXXWIN_DEBUG( "[%08X] V4L2_CREATE( BUFFERS = %d ) (2)\n", (unsigned int)pDevice, (int)pDevice->m_nVideoBufferSize );
	}

	LINUXXWIN_DEBUG( "[%08X] V4L2_CREATE( SUCCESS )\n", (unsigned int)pDevice );

	return TRUE;
		
V4L2_CREATE_FAILED:

	// DESTROY DEVICE RESOURCES
	// 
	if( pDevice->m_sVideoBuffer ) {

		int i = 0;

		for( i = 0 ; i < pDevice->m_nVideoBufferSize ; i++ ) {

			if( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer ) {

				munmap( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer, pDevice->m_sVideoBuffer[ i ].m_nKsBufferSize );

				pDevice->m_sVideoBuffer[ i ].m_nKsBufferSize = 0;

				pDevice->m_sVideoBuffer[ i ].m_pKsBuffer = NULL;
			}
		}
		free( pDevice->m_sVideoBuffer );

		pDevice->m_nVideoBufferSize = 0;

		pDevice->m_sVideoBuffer = NULL;
	}
	// DESTROY DEVICE RESOURCES
	// 
	if( pDevice->m_hHwDevice ) {

		close( pDevice->m_hHwDevice );

		pDevice->m_hHwDevice = 0x00000000;
	}
	return FALSE;
}

BOOLEAN V4L2_DESTROY( CDevice * pDevice )
{
	// DESTROY DEVICE RESOURCES
	// 
	if( pDevice->m_sVideoBuffer ) {

		ULONG i = 0;

		for( i = 0 ; i < pDevice->m_nVideoBufferSize ; i++ ) {

			if( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer ) {

				munmap( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer, pDevice->m_sVideoBuffer[ i ].m_nKsBufferSize );

				pDevice->m_sVideoBuffer[ i ].m_nKsBufferSize = 0;

				pDevice->m_sVideoBuffer[ i ].m_pKsBuffer = NULL;
			}
		}
		free( pDevice->m_sVideoBuffer );

		pDevice->m_nVideoBufferSize = 0;

		pDevice->m_sVideoBuffer = NULL;
	}
	if( pDevice->m_hHwDevice ) {

		close( pDevice->m_hHwDevice );

		pDevice->m_hHwDevice = 0x00000000;
	}
	LINUXXWIN_DEBUG( "[%08X] V4L2_DESTROY( SUCCESS )\n", (unsigned int)pDevice );

	return TRUE;
}

BOOLEAN V4L2_START( CDevice * pDevice )
{
	enum v4l2_buf_type e_v4l2_buf_type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

	ULONG i = 0;

	for( i = 0 ; i < pDevice->m_nVideoBufferSize ; i++ ) {

		if( pDevice->m_sVideoBuffer[ i ].m_pKsBuffer ) {

			struct v4l2_buffer s_v4l2_buffer;

			memset( &s_v4l2_buffer, 0x00, sizeof(struct v4l2_buffer) );

			s_v4l2_buffer.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

			s_v4l2_buffer.memory = V4L2_MEMORY_MMAP;

			s_v4l2_buffer.index = i;

			if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_QBUF, &s_v4l2_buffer ) ) { return FALSE; }
		}
	}
	if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_STREAMON, &e_v4l2_buf_type ) ) { return FALSE; }

	LINUXXWIN_DEBUG( "[%08X] V4L2_START( SUCCESS )\n", (unsigned int)pDevice );
	
	// pthread_create(); pthread_join();

	return TRUE;
}

BOOLEAN V4L2_STOP( CDevice * pDevice )
{
	enum v4l2_buf_type e_v4l2_buf_type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

	if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_STREAMOFF, &e_v4l2_buf_type ) ) { return FALSE; }

	LINUXXWIN_DEBUG( "[%08X] V4L2_STOP( SUCCESS )\n", (unsigned int)pDevice );
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// MAIN PROGRAMMING GUIDE
// 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
pthread_t g_h_custom_video_process_thread_handler = 0x00000000;

volatile BOOLEAN g_is_exit_custom_video_process_thread = FALSE;

static void on_custom_video_process_thread( void * pArguments )
{
	CDevice * pDevice = (CDevice *)(pArguments);

	CXWindow * pXWindow = (CXWindow *)(pDevice->m_pXWindow);

	LINUXXWIN_DEBUG( "[%08X] on_custom_video_process_thread( start )\n", (unsigned int)pDevice );

	while( g_is_exit_custom_video_process_thread == FALSE ) {

		fd_set s_fds;

		struct timeval s_timeval_timeout = { 2, 0 };

		int returns = 0;

		FD_ZERO( &s_fds );

		FD_SET( pDevice->m_hHwDevice, &s_fds );

		returns = select( pDevice->m_hHwDevice + 1, &s_fds, NULL, NULL, &s_timeval_timeout );

		if( ( 0 == returns) ) { continue; }

		if( (-1 == returns) && (EINTR == errno) ) { continue; }

		if( (-1 == returns) ) { goto EXIT; } // TIMEOUT

		{	struct v4l2_buffer s_v4l2_buffer;

			// PRE PROCESS
			// 
			memset( &s_v4l2_buffer, 0x00, sizeof(struct v4l2_buffer) );

			s_v4l2_buffer.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

			s_v4l2_buffer.memory = V4L2_MEMORY_MMAP;

			if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_DQBUF, &s_v4l2_buffer ) ) { goto EXIT; }

			//shawn
			int n_channel = 0;
			n_channel = s_v4l2_buffer.input & 0x00000003;// the least 2 bits

			// GC BITBLT
			//
			{	GC pGC = XCreateGC( pXWindow->m_pDisplay, pXWindow->m_hWindow, 0, NULL );

				ULONG cx_o = pXWindow->m_nXvImageWidth;

				ULONG cy_o = pXWindow->m_nXvImageHeight;

				ULONG cx_e = 0;

				ULONG cy_e = 0;

				XWindowAttributes s_window_attributes; 
				
				XGetWindowAttributes( pXWindow->m_pDisplay, pXWindow->m_hWindow, &s_window_attributes );

				cx_e = s_window_attributes.width;

				cy_e = s_window_attributes.height;

				memcpy( pXWindow->m_pXvImage->data, (BYTE *)(pDevice->m_sVideoBuffer[ s_v4l2_buffer.index ].m_pKsBuffer), cx_o * cy_o * 2 );
	
				//shawn
		//		LINUXXWIN_DEBUG("SplitNumber = %d\n", SplitNumber);
				if( SplitNumber == 4 ) {
				
					switch(n_channel){
					case 0:
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 0, 360, 240 ); break;
					case 1:
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 360, 0, 360, 240 ); break;
					case 2:
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 240, 360, 240 ); break;
					case 3:
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 360, 240, 360, 240 ); break;
					default:
						break;
					}
				}
				else if( SplitNumber == 2 ) {

					switch(n_channel) {
					#ifdef SUBCH2
					case 1:  // see Sub Channel 2
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 0, cx_e, cy_e );	
					#else
					case 0:  // see Sub Channel 1
						XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 0, cx_e, cy_e );	
					#endif
					default: 
						break;
					}
				}
				else{
					// SEE D1 Quality
					XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 0, cx_e, cy_e );	
				}

			//	XvPutImage( pXWindow->m_pDisplay, pXWindow->m_nXvAdaptorPortID, pXWindow->m_hWindow, pGC, pXWindow->m_pXvImage, 0, 0, cx_o, cy_o, 0, 0, cx_e, cy_e );

				XFreeGC( pXWindow->m_pDisplay, pGC );
			}

		//	//	TIMESTAMP (DEBUG)
		//	// 
		//	{	struct timeval ts; 
		//		
		//		gettimeofday( &ts, NULL ); 
		//	
		//		LINUXXWIN_DEBUG( "%d.%06d\n", (ts.tv_sec), (ts.tv_usec) );
		//	}

			// POST PROCESS
			// 
			s_v4l2_buffer.flags = 0x00000000; // CLEAR FLAGS (NOTE!! YOU NEED CLEAR THE FLAGS BEFORE QBUF)

			if( FALSE == V4L2_IOCTL( pDevice, VIDIOC_QBUF, &s_v4l2_buffer ) ) { goto EXIT; }
		}
	}

EXIT:

	LINUXXWIN_DEBUG( "[%08X] on_custom_video_process_thread( stop )\n", (unsigned int)pDevice );
}

static void usage (FILE * fp, int argc, char ** argv) {
	fprintf (fp,
			"Usage: %s [options]\n\n"
			"Options:\n"
			"-d | --device name Video device name [/dev/video]\n"
			"-s | --split_channel support value: 1 or 4 \n"
			"-h | --help Print this message\n\n"
			"example: device 2, 1 chipset split to 4 channels \n"
			"         LINUXXWIN -d /dev/video1 -s 4 \n\n"
			"",
			argv[0]);
}

static const char short_options [] = "d:s:h";

static const struct option long_options [] = {

	{ "device",			required_argument,	NULL,	'd' },
	{ "split_channel",	required_argument,	NULL,	's' },
	{ "help",			no_argument,		NULL,	'h' },
	{ 0,				0,					0,		0	}
};

int main( int argc, char * argv[ ] )
{ 
	CHAR     pszWindowTitleName[ 64 ] = "My XWindow Demo Software - /dev/video0";

	CHAR     pszDeviceName[ 64 ] = "/dev/video0";

	CXWindow sXWindow;

	CDevice  sDevice;

	int SplitValue = REAL_TIME;

	int arg;

	memset( &sXWindow, 0x00, sizeof(CXWindow) );

	memset( &sDevice, 0x00, sizeof(CDevice) );

	// PROCESS USER COMMAND #./LINUXXWIN /dev/video0
	//
	for (;;) {

		int index, c;

		c =  getopt_long( argc, argv,short_options, long_options, &index );

		if ( -1 == c ) break;

		switch (c) {
		case 0: /* getopt_long() flag */
			break;
		case 'd':
			sprintf( pszDeviceName, "%s", optarg );
			sprintf( pszWindowTitleName, "My XWindow Demo Software - %s", pszDeviceName );
			break;
		case 's':
			SplitNumber = atoi(optarg);
			if( SplitNumber == 1 )
					SplitValue = REAL_TIME;
			else if( SplitNumber == 4 )
				SplitValue = SPLIT_4;
			else if( SplitNumber == 2 )
				SplitValue = SPLIT_2;
			else
				SplitValue = REAL_TIME;
			break;
		case 'h':
			usage (stdout, argc, argv);
			exit (EXIT_SUCCESS);
		default:
			usage (stderr, argc, argv);
			exit (EXIT_FAILURE);
		}
	}

	if( DEFAULT_VIDEO_STANDARD == V4L2_STD_PAL_B ){

		width  = 704;
		height = 576;
	}
	else {

		width  = 704;
		height = 480;
	}

	// CREATE XWINDOW
	//
	if( FALSE == XWINDOW_CREATE( &sXWindow, 0, 0, width, height, 2, pszWindowTitleName ) )  {

		goto EXIT;
	}

	// CREATE XVIDEO.EXTENSION
	//
	if( FALSE == XVIDEO_CREATE( &sXWindow, 0x32595559, width, height ) ) { // SC200/SC220/SC300/SC310/SC390 (YUY2)

		goto EXIT;
	}

	// CREATE V4L2 DEVICE
	//
	if( FALSE == V4L2_CREATE( &sDevice, pszDeviceName, 0x32595559, width, height, &sXWindow ) ) { // SC200/SC220/SC300/SC310/SC390 (YUY2)

		goto EXIT;
	}

	SET VIDEO STANDARD
	ULONG video_standard = DEFAULT_VIDEO_STANDARD;	
	V4L2_IOCTL( &sDevice, VIDIOC_S_STD, &video_standard );

	//SET SWITCH TABLE
	struct v4l2_control s_ctrl;

	s_ctrl.id = V4L2_CID_SWITCH_TABLE;
	
	s_ctrl.value = SplitValue; 
	
	V4L2_IOCTL( &sDevice, VIDIOC_S_CTRL, &s_ctrl );
	

	// START V4L2 DEVICE
	//
	if( FALSE == V4L2_START( &sDevice ) ) {

		goto EXIT;
	}

	// START PTHREAD
	//
	if( 0 != pthread_create( &g_h_custom_video_process_thread_handler, NULL, (void *)(on_custom_video_process_thread), (void *)(&sDevice) ) ) {

		g_h_custom_video_process_thread_handler = 0x00000000;

		goto EXIT;
	}

	// PROCESS WINDOWS MESSAGES
	//
	XSelectInput( sXWindow.m_pDisplay, sXWindow.m_hWindow, ExposureMask | ButtonPressMask | KeyPressMask );
		
	while( TRUE ) { // MAIN LOOP

		XEvent s_event; 
		
		XNextEvent( sXWindow.m_pDisplay, &s_event ); 

		if( s_event.type == KeyPress ) { 
		
			KeySym n_key_sym;
			
			CHAR p_key_buffer[ 64 ];

			int n_key_count = XLookupString( &s_event, p_key_buffer, sizeof(p_key_buffer), &n_key_sym, NULL );
			
			if( n_key_count > 0 ) {

				if( p_key_buffer[ 0 ] == XK_q ) { break; } // EXIT

				if( p_key_buffer[ 0 ] == XK_Q ) { break; } // EXIT
			}
		}
		if (s_event.type == ButtonPress ) { ; }

		if (s_event.type == Expose ) { ; }
	}

EXIT:

	// STOP PTHREAD
	//
	if( g_h_custom_video_process_thread_handler ) { 
		
		g_is_exit_custom_video_process_thread = TRUE;

		pthread_join( g_h_custom_video_process_thread_handler, NULL );
	}
	// STOP V4L2 DEVICE
	//
	V4L2_STOP( &sDevice );

	// DESTORY V4L2 DEVICE
	//
	V4L2_DESTROY( &sDevice );

	// DESTORY XVIDEO.EXTENSION
	//
	XVIDEO_DESTROY( &sXWindow );

	// DESTORY XWINDOW
	//
	XWINDOW_DESTROY( &sXWindow );

	return 0;
} 
